/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.graph.component.widget;

import com.google.inject.Inject;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.orienteer.core.behavior.UpdateOnActionPerformedEventBehavior;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.Command;
import org.orienteer.core.component.command.EditODocumentsCommand;
import org.orienteer.core.component.command.SaveODocumentsCommand;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.table.OrienteerDataTable;
import org.orienteer.core.component.table.component.GenericTablePanel;
import org.orienteer.core.model.ODocumentNameModel;
import org.orienteer.core.service.impl.OClassIntrospector;
import org.orienteer.core.widget.AbstractWidget;
import org.orienteer.core.widget.Widget;
import org.orienteer.graph.component.command.CreateEdgeCommand;
import org.orienteer.graph.component.command.CreateVertexCommand;
import org.orienteer.graph.component.command.DeleteVertexCommand;
import org.orienteer.graph.component.command.UnlinkVertexCommand;
import ru.ydn.wicket.wicketorientdb.behavior.DisableIfDocumentNotSavedBehavior;
import ru.ydn.wicket.wicketorientdb.model.OQueryDataProvider;

@Widget(id="neighbors", domain="document", order=10, autoEnable=true, selector="V")
public class GraphNeighborsWidget
extends AbstractWidget<ODocument> {
    @Inject
    private OClassIntrospector oClassIntrospector;

    public GraphNeighborsWidget(String id, IModel<ODocument> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
        IModel modeModel = DisplayMode.VIEW.asModel();
        OQueryDataProvider provider = new OQueryDataProvider("select expand(both()) from " + ((ODocument)this.getModelObject()).getIdentity());
        OClass commonParent = provider.probeOClass(20);
        if (commonParent == null) {
            commonParent = this.getSchema().getClass("V");
        }
        List columns = this.oClassIntrospector.getColumnsFor(commonParent, true, modeModel);
        GenericTablePanel tablePanel = new GenericTablePanel("neighbors", columns, provider, 20);
        OrienteerDataTable table = tablePanel.getDataTable();
        table.addCommand((Command)new CreateVertexCommand(table, (IModel<ODocument>)this.getModel()));
        table.addCommand((Command)new CreateEdgeCommand(table, (IModel<ODocument>)this.getModel()));
        table.addCommand((Command)new UnlinkVertexCommand(table, (IModel<ODocument>)this.getModel()));
        table.addCommand((Command)new DeleteVertexCommand(table, (IModel<ODocument>)this.getModel()));
        table.addCommand((Command)new EditODocumentsCommand(table, modeModel, commonParent));
        table.addCommand((Command)new SaveODocumentsCommand(table, modeModel));
        this.add(new Component[]{tablePanel});
        this.add(new Behavior[]{DisableIfDocumentNotSavedBehavior.INSTANCE, UpdateOnActionPerformedEventBehavior.INSTANCE_ALL_CONTINUE});
    }

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.arrows_h);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new StringResourceModel("widget.document.neighbours.title", (IModel)new ODocumentNameModel(this.getModel()));
    }

    protected String getWidgetStyleClass() {
        return "strict";
    }
}

