/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.graph.module;

import com.google.inject.Singleton;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.module.AbstractOrienteerModule;
import org.orienteer.core.util.OSchemaHelper;

@Singleton
public class GraphModule
extends AbstractOrienteerModule {
    public static final String NAME = "graph";
    public static final String EDGE_CLASS_NAME = "E";
    public static final String VERTEX_CLASS_NAME = "V";

    protected GraphModule() {
        super(NAME, 1);
    }

    public ODocument onInstall(OrienteerWebApplication app, ODatabaseDocument db) {
        this.onUpdate(app, db, 0, this.getVersion());
        return null;
    }

    public void onUpdate(OrienteerWebApplication app, ODatabaseDocument db, int oldVersion, int newVersion) {
        if (oldVersion >= newVersion) {
            return;
        }
        switch (oldVersion + 1) {
            case 1: {
                this.onUpdateToFirstVesion(app, db);
                break;
            }
        }
        if (oldVersion + 1 < newVersion) {
            this.onUpdate(app, db, oldVersion + 1, newVersion);
        }
    }

    public void onUpdateToFirstVesion(OrienteerWebApplication app, ODatabaseDocument db) {
        OSchemaHelper helper = OSchemaHelper.bind((ODatabaseDocument)db);
        helper.oClass(VERTEX_CLASS_NAME, new String[0]).oClass(EDGE_CLASS_NAME, new String[0]);
    }

    public void onInitialize(OrienteerWebApplication app, ODatabaseDocument db) {
        app.registerWidgets("org.orienteer.graph.component.widget");
    }

    public void onDestroy(OrienteerWebApplication app, ODatabaseDocument db) {
        app.unregisterWidgets("org.orienteer.graph.component.widget");
    }
}

