/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.graph.component.widget;

import com.google.common.base.Function;
import com.google.inject.Inject;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.orienteer.core.behavior.UpdateOnActionPerformedEventBehavior;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.Command;
import org.orienteer.core.component.command.EditODocumentsCommand;
import org.orienteer.core.component.command.ExportCommand;
import org.orienteer.core.component.command.SaveODocumentsCommand;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.table.ODocumentClassColumn;
import org.orienteer.core.component.table.ODocumentDescriptionColumn;
import org.orienteer.core.component.table.OrienteerDataTable;
import org.orienteer.core.component.table.component.GenericTablePanel;
import org.orienteer.core.model.ODocumentNameModel;
import org.orienteer.core.service.impl.OClassIntrospector;
import org.orienteer.core.widget.AbstractWidget;
import org.orienteer.core.widget.Widget;
import ru.ydn.wicket.wicketorientdb.behavior.DisableIfDocumentNotSavedBehavior;
import ru.ydn.wicket.wicketorientdb.model.OClassModel;
import ru.ydn.wicket.wicketorientdb.model.OQueryDataProvider;

@Widget(id="vertices", domain="document", order=10, autoEnable=true, selector="E")
public class GraphVerticesWidget
extends AbstractWidget<ODocument> {
    @Inject
    private OClassIntrospector oClassIntrospector;

    public GraphVerticesWidget(String id, IModel<ODocument> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
    }

    protected void onInitialize() {
        super.onInitialize();
        IModel modeModel = DisplayMode.VIEW.asModel();
        String sql = "select expand(bothV()) from " + ((ODocument)this.getModelObject()).getIdentity();
        OQueryDataProvider provider = new OQueryDataProvider(sql);
        OClass commonParent = provider.probeOClass(20);
        GenericTablePanel tablePanel = new GenericTablePanel("vertices", this.createColumns(commonParent, (IModel<DisplayMode>)modeModel), provider, 2);
        OrienteerDataTable table = tablePanel.getDataTable();
        table.addCommand((Command)new EditODocumentsCommand(table, modeModel, commonParent));
        table.addCommand((Command)new SaveODocumentsCommand(table, modeModel));
        table.addCommand((Command)new ExportCommand(table, (IModel)new StringResourceModel("export.filename.vertices", (IModel)new ODocumentNameModel(this.getModel()))));
        this.add(new Component[]{tablePanel});
        this.add(new Behavior[]{DisableIfDocumentNotSavedBehavior.INSTANCE, UpdateOnActionPerformedEventBehavior.INSTANCE_ALL_CONTINUE});
    }

    private List<IColumn<ODocument, String>> createColumns(OClass commonParent, IModel<DisplayMode> modeModel) {
        OProperty nameProperty = this.oClassIntrospector.getNameProperty(commonParent);
        List columns = this.oClassIntrospector.getColumnsFor(commonParent, true, modeModel);
        columns.add(new ODocumentClassColumn((IModel)new OClassModel(commonParent)));
        columns.add(new ODocumentDescriptionColumn((IModel)new StringResourceModel("property.direction", (Component)this, (IModel)Model.of()), (Function)new DirectionLocalizer()));
        return columns;
    }

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.arrows_h);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new StringResourceModel("widget.document.vertices.title", (IModel)new ODocumentNameModel(this.getModel()));
    }

    protected String getWidgetStyleClass() {
        return "strict";
    }

    private class DirectionLocalizer
    implements Function<ODocument, String>,
    Serializable {
        private DirectionLocalizer() {
        }

        public String apply(ODocument vertex) {
            Object fieldIn = ((ODocument)GraphVerticesWidget.this.getModelObject()).field("in");
            String direction = fieldIn != null ? (((OIdentifiable)fieldIn).getIdentity().equals(vertex.getIdentity()) ? "in" : "out") : "empty";
            return GraphVerticesWidget.this.getLocalizer().getString("widget.document.vertices.title." + direction, (Component)GraphVerticesWidget.this);
        }
    }
}

