package org.orienteer.notifications.model;

import com.google.inject.ProvidedBy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.orienteer.core.dao.DAOField;
import org.orienteer.core.dao.DAOOClass;
import org.orienteer.core.dao.ODocumentWrapperProvider;
import org.orienteer.mail.model.OMailSettings;

/**
 * Wrapper for class {@link IOMailNotificationTransport#CLASS_NAME}
 */
@ProvidedBy(ODocumentWrapperProvider.class)
@DAOOClass(value = IOMailNotificationTransport.CLASS_NAME)
public interface IOMailNotificationTransport extends IONotificationTransport {

  String CLASS_NAME = "OMailNotificationTransport";

  @DAOField(linkedClass = OMailSettings.CLASS_NAME, type = OType.LINK)
  ODocument getMailSettings();
  IOMailNotificationTransport setMailSettings(ODocument mailSettings);

}
