/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.notifications.hook;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.notifications.model.IONotification;
import org.orienteer.notifications.model.IONotificationDAO;
import org.orienteer.notifications.model.IONotificationStatusHistory;
import org.orienteer.notifications.service.IONotificationFactory;

public class ONotificationHook
extends ODocumentHookAbstract {
    public ONotificationHook(ODatabaseDocument database) {
        super(database);
        this.setIncludeClasses(new String[]{"ONotification"});
    }

    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.SOURCE_NODE;
    }

    public ORecordHook.RESULT onRecordBeforeCreate(ODocument doc) {
        boolean changed = false;
        IONotification notification = ((IONotificationFactory)OrienteerWebApplication.lookupApplication().getServiceInstance(IONotificationFactory.class)).create(doc);
        if (notification == null) {
            throw new OValidationException("Not supported 'ONotification' subclass!");
        }
        if (notification.getId() == null) {
            notification.setId(UUID.randomUUID().toString());
            changed = true;
        }
        if (notification.getCreated() == null) {
            notification.setCreated(new Date());
            changed = true;
        }
        if (notification.getStatus() == null) {
            ODocument pendingStatus = IONotificationDAO.get().getPendingStatus();
            notification.setStatus(pendingStatus);
            IONotificationStatusHistory history = IONotificationStatusHistory.create(new Date(), pendingStatus);
            history.save();
            notification.addStatusHistory(history);
            changed = true;
        }
        return changed ? ORecordHook.RESULT.RECORD_CHANGED : super.onRecordBeforeCreate(doc);
    }

    public ORecordHook.RESULT onRecordBeforeDelete(ODocument doc) {
        boolean changed = false;
        IONotification notification = ((IONotificationFactory)OrienteerWebApplication.lookupApplication().getServiceInstance(IONotificationFactory.class)).create(doc);
        if (notification == null) {
            throw new OValidationException("Not supported 'ONotification' subclass!");
        }
        List<ODocument> history = notification.getStatusHistories();
        if (!history.isEmpty()) {
            history.forEach(arg_0 -> ((ODatabaseDocument)this.database).delete(arg_0));
            notification.setStatusHistories(null);
            changed = true;
        }
        return changed ? ORecordHook.RESULT.RECORD_CHANGED : super.onRecordBeforeDelete(doc);
    }
}

