/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.notifications.model;

import com.google.inject.ProvidedBy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.dao.DAOProvider;
import org.orienteer.core.dao.Query;

@ProvidedBy(value=DAOProvider.class)
public interface IONotificationDAO {
    public static IONotificationDAO get() {
        return (IONotificationDAO)OrienteerWebApplication.lookupApplication().getServiceInstance(IONotificationDAO.class);
    }

    @Query(value="select from ONotification where status = :status")
    public List<ODocument> findNotificationsByStatus(ODocument var1);

    @Query(value="select from ONotification where status != :status")
    public List<ODocument> findNotificationsExceptStatus(ODocument var1);

    @Query(value="select from ONotificationStatus where alias = :alias")
    public ODocument findStatusByAlias(String var1);

    @Query(value="select from ONotificationTransport where alias = :alias")
    public ODocument findTransportByAlias(String var1);

    default public ODocument getPendingStatus() {
        return this.findStatusByAlias("pending");
    }

    default public ODocument getSendingStatus() {
        return this.findStatusByAlias("sending");
    }

    default public ODocument getSentStatus() {
        return this.findStatusByAlias("sent");
    }

    default public ODocument getFailedStatus() {
        return this.findStatusByAlias("failed");
    }
}

