/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.notifications.model;

import com.google.common.base.Strings;
import com.google.inject.ProvidedBy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.orienteer.core.dao.DAOOClass;
import org.orienteer.core.dao.IODocumentWrapper;
import org.orienteer.core.dao.ODocumentWrapperProvider;
import org.orienteer.notifications.service.ITransport;

@ProvidedBy(value=ODocumentWrapperProvider.class)
@DAOOClass(value="ONotificationTransport", isAbstract=true)
public interface IONotificationTransport
extends IODocumentWrapper {
    public static final String CLASS_NAME = "ONotificationTransport";

    public String getAlias();

    public IONotificationTransport setAlias(String var1);

    public Map<String, String> getName();

    public IONotificationTransport setName(Map<String, String> var1);

    public String getTransportClass();

    public IONotificationTransport setTransportClass(String var1);

    default public ITransport createTransportService() {
        String transportClass = this.getTransportClass();
        if (!Strings.isNullOrEmpty((String)transportClass)) {
            try {
                Constructor<?> constructor = Class.forName(transportClass).getConstructor(ODocument.class);
                return (ITransport)constructor.newInstance(this.getDocument());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

