/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.notifications.module;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.List;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.dao.DAO;
import org.orienteer.core.module.AbstractOrienteerModule;
import org.orienteer.core.util.CommonUtils;
import org.orienteer.core.util.OSchemaHelper;
import org.orienteer.notifications.hook.ONotificationHook;
import org.orienteer.notifications.model.IOMailNotification;
import org.orienteer.notifications.model.IOMailNotificationTransport;
import org.orienteer.notifications.model.IONotification;
import org.orienteer.notifications.model.IONotificationDAO;
import org.orienteer.notifications.model.IONotificationStatus;
import org.orienteer.notifications.model.IONotificationStatusHistory;
import org.orienteer.notifications.model.IONotificationTransport;
import org.orienteer.notifications.model.IOSmsNotification;
import org.orienteer.notifications.model.IOSmsNotificationTransport;
import org.orienteer.notifications.scheduler.ONotificationScheduler;
import org.orienteer.notifications.scheduler.ONotificationTask;
import org.orienteer.notifications.task.ONotificationSendTask;

public class ONotificationModule
extends AbstractOrienteerModule {
    public static final String NAME = "orienteer-notification";
    public static final int VERSION = 2;

    protected ONotificationModule() {
        super(NAME, 2, new String[]{"orienteer-mail", "orienteer-twilio"});
    }

    public ODocument onInstall(OrienteerWebApplication app, ODatabaseDocument db) {
        OSchemaHelper helper = OSchemaHelper.bind((ODatabaseDocument)db);
        DAO.describe((OSchemaHelper)helper, (Class[])new Class[]{IONotification.class, IONotificationStatus.class, IONotificationTransport.class, IONotificationStatusHistory.class});
        DAO.describe((OSchemaHelper)helper, (Class[])new Class[]{IOMailNotification.class, IOMailNotificationTransport.class});
        DAO.describe((OSchemaHelper)helper, (Class[])new Class[]{IOSmsNotification.class, IOSmsNotificationTransport.class});
        this.installNotificationStatus(helper);
        return this.createModuleDocument(helper);
    }

    private ODocument createModuleDocument(OSchemaHelper helper) {
        helper.oClass("ONotificationModule", new String[]{"OModule"}).oProperty("sendPeriod", OType.LONG).notNull().defaultValue("60000").oProperty("notificationsPerWorker", OType.INTEGER).notNull().defaultValue("50").oProperty("smsStatusUrl", OType.STRING);
        return helper.oDocument("name", (Object)NAME).saveDocument().getODocument();
    }

    private void installNotificationStatus(OSchemaHelper helper) {
        IONotificationStatus status = (IONotificationStatus)DAO.create(IONotificationStatus.class, (Class[])new Class[0]);
        IONotificationDAO statusDao = IONotificationDAO.get();
        if (statusDao.getPendingStatus() == null) {
            status.fromStream(new ODocument("ONotificationStatus"));
            status.setAlias("pending");
            status.setName(CommonUtils.toMap((Object[])new Object[]{"en", new ResourceModel("notification.status.pending").getObject()}));
            status.save();
        }
        if (statusDao.getSendingStatus() == null) {
            status.fromStream(new ODocument("ONotificationStatus"));
            status.setAlias("sending");
            status.setName(CommonUtils.toMap((Object[])new Object[]{"en", new ResourceModel("notification.status.sending").getObject()}));
            status.save();
        }
        if (statusDao.getSentStatus() == null) {
            status.fromStream(new ODocument("ONotificationStatus"));
            status.setAlias("sent");
            status.setName(CommonUtils.toMap((Object[])new Object[]{"en", new ResourceModel("notification.status.sent").getObject()}));
            status.save();
        }
        if (statusDao.getFailedStatus() == null) {
            status.fromStream(new ODocument("ONotificationStatus"));
            status.setAlias("failed");
            status.setName(CommonUtils.toMap((Object[])new Object[]{"en", new ResourceModel("notification.status.failed").getObject()}));
            status.save();
        }
    }

    public void onUpdate(OrienteerWebApplication app, ODatabaseDocument db, int oldVersion, int newVersion) {
        this.onInstall(app, db);
    }

    public void onInitialize(OrienteerWebApplication app, ODatabaseDocument db, ODocument moduleDoc) {
        super.onInitialize(app, db, moduleDoc);
        List hooks = app.getOrientDbSettings().getORecordHooks();
        hooks.add(ONotificationHook.class);
        long period = new Module(moduleDoc).getSendPeriod();
        ONotificationScheduler.scheduleTask((ONotificationTask)new ONotificationSendTask(), period);
    }

    public void onDestroy(OrienteerWebApplication app, ODatabaseDocument db, ODocument moduleDoc) {
        super.onDestroy(app, db, moduleDoc);
        List hooks = app.getOrientDbSettings().getORecordHooks();
        hooks.remove(ONotificationHook.class);
        ONotificationScheduler.stopAll();
    }

    public static class Module
    extends ODocumentWrapper {
        public static final String CLASS_NAME = "ONotificationModule";
        public static final String PROP_SEND_PERIOD = "sendPeriod";
        public static final String PROP_NOTIFICATIONS_PER_WORKER = "notificationsPerWorker";
        public static final String PROP_SMS_STATUS_URL = "smsStatusUrl";

        public Module() {
            this(CLASS_NAME);
        }

        public Module(String iClassName) {
            super(iClassName);
        }

        public Module(ODocument iDocument) {
            super(iDocument);
        }

        public long getSendPeriod() {
            Long period = (Long)this.document.field(PROP_SEND_PERIOD);
            return period != null ? period : 60000L;
        }

        public Module setSendPeriod(long period) {
            this.document.field(PROP_SEND_PERIOD, (Object)period);
            return this;
        }

        public int getNotificationsPerWorker() {
            Integer notifications = (Integer)this.document.field(PROP_NOTIFICATIONS_PER_WORKER);
            return notifications != null ? notifications : 50;
        }

        public Module setNotificationsPerWorker(int notifications) {
            this.document.field(PROP_NOTIFICATIONS_PER_WORKER, (Object)notifications);
            return this;
        }

        public String getSmsStatusUrl() {
            return (String)this.document.field(PROP_SMS_STATUS_URL);
        }

        public Module setSmsStatusUrl(String smsStatusUrl) {
            this.document.field(PROP_SMS_STATUS_URL, (Object)smsStatusUrl);
            return this;
        }
    }
}

