/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.notifications.scheduler;

import com.orientechnologies.orient.core.Orient;
import java.util.Date;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.orienteer.notifications.scheduler.ONotificationTask;

public final class ONotificationScheduler {
    private static final ConcurrentHashMap<String, ONotificationTask> TASKS = new ConcurrentHashMap();

    private ONotificationScheduler() {
    }

    public static void scheduleTask(ONotificationTask task, Date firstTime) {
        ONotificationScheduler.scheduleTask(task, firstTime, 0L);
    }

    public static void scheduleTask(ONotificationTask task, long delay) {
        ONotificationScheduler.scheduleTask(task, delay, 0L);
    }

    public static void scheduleTask(ONotificationTask task, Date firstTime, long period) {
        ONotificationScheduler.stopTask(task.getName());
        TASKS.put(task.getName(), task);
        Orient.instance().scheduleTask((TimerTask)task, firstTime, period);
    }

    public static void scheduleTask(ONotificationTask task, long delay, long period) {
        ONotificationScheduler.stopTask(task.getName());
        TASKS.put(task.getName(), task);
        Orient.instance().scheduleTask((TimerTask)task, delay, period);
    }

    public static synchronized void stopTask(String name) {
        ONotificationTask task = TASKS.remove(name);
        if (task != null) {
            task.cancel();
        }
    }

    public static void stopAll() {
        ((ConcurrentHashMap.KeySetView)TASKS.keySet()).forEach(ONotificationScheduler::stopTask);
    }
}

