/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.notifications.service;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Date;
import java.util.List;
import org.orienteer.core.dao.DAO;
import org.orienteer.notifications.model.IONotification;
import org.orienteer.notifications.model.IONotificationDAO;
import org.orienteer.notifications.model.IONotificationStatusHistory;
import org.orienteer.notifications.model.IONotificationTransport;
import org.orienteer.notifications.service.INotificationService;
import org.orienteer.notifications.service.ITransport;
import org.orienteer.notifications.service.OTransportPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NotificationService
implements INotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationService.class);
    public static final int ATTEMPTS = 3;
    private final OTransportPool transportPool = new OTransportPool();
    @Inject
    private IONotificationDAO notificationDAO;

    @Override
    public void send(List<ODocument> notifications) {
        if (notifications == null || notifications.isEmpty()) {
            return;
        }
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        IONotification notification = (IONotification)DAO.create(IONotification.class, (Class[])new Class[0]);
        IONotificationTransport transportWrapper = (IONotificationTransport)DAO.create(IONotificationTransport.class, (Class[])new Class[0]);
        notifications.forEach(arg_0 -> this.lambda$send$0(notification, transportWrapper, (ODatabaseDocument)db, arg_0));
    }

    private void handleSendingNotificationStatus(ODatabaseDocument db, IONotification notification) {
        ODocument status = this.notificationDAO.getSendingStatus();
        this.updateNotificationStatus(db, notification, status);
    }

    private void handleSentNotificationStatus(ODatabaseDocument db, IONotification notification) {
        ODocument status = this.notificationDAO.getSentStatus();
        this.updateNotificationStatus(db, notification, status);
    }

    private void handleFailedNotificationStatus(ODatabaseDocument db, IONotification notification, Exception e) {
        ODocument status = this.notificationDAO.getFailedStatus();
        LOG.warn("Couldn't send notification: {}", (Object)notification.getDocument(), (Object)e);
        this.updateNotificationStatus(db, notification, status);
    }

    private void updateNotificationStatus(ODatabaseDocument db, IONotification notification, ODocument status) {
        for (int i = 1; i <= 10; ++i) {
            try {
                db.begin();
                notification.addStatusHistory(IONotificationStatusHistory.create(new Date(), status));
                notification.setStatus(status);
                notification.save();
                db.commit();
                break;
            }
            catch (Exception e) {
                if (i == 10) {
                    LOG.error("Couldn't save notification: {}", (Object)notification.getDocument(), (Object)e);
                    continue;
                }
                notification.reload();
                continue;
            }
        }
    }

    private /* synthetic */ void lambda$send$0(IONotification notification, IONotificationTransport transportWrapper, ODatabaseDocument db, ODocument notificationDoc) {
        notification.fromStream(notificationDoc);
        transportWrapper.fromStream(notification.getTransport());
        ITransport transport = this.transportPool.acquire(transportWrapper.getAlias(), transportWrapper::createTransportService);
        for (int i = 1; i <= 3; ++i) {
            try {
                if (i == 1) {
                    this.handleSendingNotificationStatus(db, notification);
                }
                LOG.info("Send notification: {} {}", (Object)Thread.currentThread().getName(), (Object)notification.getDocument());
                transport.send(notificationDoc);
                this.handleSentNotificationStatus(db, notification);
                this.transportPool.release(transportWrapper.getAlias(), transport);
                break;
            }
            catch (Exception e) {
                if (i != 3) continue;
                this.handleFailedNotificationStatus(db, notification, e);
                continue;
            }
        }
    }
}

