/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.notifications.service;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.orienteer.core.dao.DAO;
import org.orienteer.mail.model.OMailAttachment;
import org.orienteer.mail.model.OMailSettings;
import org.orienteer.mail.model.OPreparedMail;
import org.orienteer.notifications.model.IOMailNotification;
import org.orienteer.notifications.model.IOMailNotificationTransport;
import org.orienteer.notifications.service.ITransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMailTransport
implements ITransport {
    private static final Logger LOG = LoggerFactory.getLogger(OMailTransport.class);
    public static final int CONNECTION_ATTEMPTS = 3;
    private final OMailSettings settings;
    private final Session session;
    private final Transport transport;

    public OMailTransport(ODocument transportDocument) {
        IOMailNotificationTransport transport = (IOMailNotificationTransport)DAO.create(IOMailNotificationTransport.class, (Class[])new Class[0]);
        transport.fromStream(transportDocument);
        this.settings = new OMailSettings(transport.getMailSettings());
        this.session = this.createSession(this.settings, this.createSendMailProperties(this.settings));
        try {
            this.transport = this.session.getTransport("smtp");
            this.connect();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't create inner transport for: " + transport, e);
        }
    }

    @Override
    public void send(ODocument notification) {
        IOMailNotification mailNotification = (IOMailNotification)DAO.create(IOMailNotification.class, (Class[])new Class[0]);
        mailNotification.fromStream(notification);
        LOG.info("Send mail notification: {} {}", (Object)notification, (Object)this.transport.isConnected());
        this.connect();
        MimeMessage message = new MimeMessage(this.session);
        OPreparedMail mail = new OPreparedMail(mailNotification.getPreparedMail());
        try {
            Address[] recipients = this.toAddressArray(mail.getRecipients());
            message.setRecipients(Message.RecipientType.TO, recipients);
            message.setRecipients(Message.RecipientType.BCC, this.toAddressArray(mail.getBcc()));
            message.setFrom((Address)this.createFrom(mail, this.settings));
            message.setSubject(mail.getSubject());
            message.setContent(this.createMessageContent(mail));
            this.transport.sendMessage((Message)message, recipients);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't send notification: " + notification, e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.transport.isConnected()) {
                this.transport.close();
            }
        }
        catch (MessagingException e) {
            LOG.error("Can't close inner transport: {}", (Object)this.transport, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        OMailTransport oMailTransport = this;
        synchronized (oMailTransport) {
            if (!this.transport.isConnected()) {
                for (int i = 1; i <= 3; ++i) {
                    try {
                        this.transport.connect();
                        Thread.sleep(500L);
                        break;
                    }
                    catch (MessagingException e) {
                        if (i != 3) continue;
                        throw new IllegalStateException(e);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private Multipart createMessageContent(OPreparedMail mail) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)this.createTextPart(mail));
        this.addMailAttachments((Multipart)multipart, mail);
        return multipart;
    }

    private void addMailAttachments(Multipart multipart, OPreparedMail mail) throws MessagingException {
        List attachments = mail.getAttachments();
        if (!attachments.isEmpty()) {
            for (OMailAttachment attachment : attachments) {
                multipart.addBodyPart(this.createDataPart(attachment.toDataSource()));
            }
        }
    }

    private MimeBodyPart createTextPart(OPreparedMail mail) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)mail.getText(), "text/html;charset=UTF-8");
        return bodyPart;
    }

    private BodyPart createDataPart(DataSource dataSource) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setDataHandler(new DataHandler(dataSource));
        bodyPart.setFileName(dataSource.getName());
        return bodyPart;
    }

    private InternetAddress createFrom(OPreparedMail mail, OMailSettings settings) throws UnsupportedEncodingException {
        return new InternetAddress(settings.getEmail(), mail.getFrom());
    }

    private Address[] toAddressArray(List<String> recipients) throws AddressException {
        Address[] addresses = new Address[recipients.size()];
        for (int i = 0; i < recipients.size(); ++i) {
            addresses[i] = new InternetAddress(recipients.get(i));
        }
        return addresses;
    }

    private Properties createSendMailProperties(OMailSettings settings) {
        Properties properties = new Properties();
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.starttls.enable", (Object)settings.isTlsSsl());
        properties.put("mail.smtp.host", settings.getSmtpHost());
        properties.put("mail.smtp.port", (Object)settings.getSmtpPort());
        return properties;
    }

    protected Session createSession(final OMailSettings settings, Properties properties) {
        return Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(settings.getEmail(), settings.getPassword());
            }
        });
    }
}

