/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.notifications.service;

import com.google.common.base.Strings;
import com.orientechnologies.orient.core.record.impl.ODocument;
import io.reactivex.Completable;
import java.io.IOException;
import java.util.List;
import okhttp3.Credentials;
import org.orienteer.core.dao.DAO;
import org.orienteer.notifications.model.IOSmsNotification;
import org.orienteer.notifications.model.IOSmsNotificationTransport;
import org.orienteer.notifications.repository.ONotificationModuleRepository;
import org.orienteer.notifications.service.ITransport;
import org.orienteer.twilio.model.OPreparedSMS;
import org.orienteer.twilio.model.OSmsSettings;
import org.orienteer.twilio.service.ITwilioService;
import org.orienteer.twilio.util.OTwilioUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSmsTransport
implements ITransport {
    private static final Logger LOG = LoggerFactory.getLogger(OSmsTransport.class);
    private final String accountSid;
    private final String authToken;
    private final String from;
    private final String callback;
    private final ITwilioService twilioService;

    public OSmsTransport(ODocument transportDocument) {
        IOSmsNotificationTransport transport = (IOSmsNotificationTransport)DAO.create(IOSmsNotificationTransport.class, (Class[])new Class[0]);
        transport.fromStream(transportDocument);
        OSmsSettings settings = new OSmsSettings(transport.getSmsSettings());
        this.accountSid = settings.getTwilioAcountSid();
        this.authToken = settings.getTwilioAuthToken();
        this.from = settings.getTwilioPhoneNumber();
        this.twilioService = OTwilioUtils.getService();
        this.callback = ONotificationModuleRepository.getModule().getSmsStatusUrl();
    }

    @Override
    public void send(ODocument notification) {
        IOSmsNotification smsNotification = (IOSmsNotification)DAO.create(IOSmsNotification.class, (Class[])new Class[0]);
        smsNotification.fromStream(notification);
        LOG.info("Send notification: {}", (Object)notification);
        this.sendMessage(smsNotification).blockingAwait();
    }

    private Completable sendMessage(IOSmsNotification notification) {
        OPreparedSMS preparedSms = new OPreparedSMS(notification.getPreparedSms());
        List attachments = preparedSms.getAttachments();
        String auth = Credentials.basic((String)this.accountSid, (String)this.authToken);
        if (Strings.isNullOrEmpty((String)this.callback)) {
            return this.twilioService.sendMessage(this.accountSid, preparedSms.getRecipient(), this.from, preparedSms.getText(), attachments, auth);
        }
        return this.twilioService.sendMessage(this.accountSid, preparedSms.getRecipient(), this.from, preparedSms.getText(), attachments, this.callback, auth);
    }

    @Override
    public void close() throws IOException {
    }
}

