/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.notifications.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.orienteer.notifications.service.ITransport;

public class OTransportPool {
    private final Map<String, ConcurrentLinkedQueue<ITransport>> resources = new ConcurrentHashMap<String, ConcurrentLinkedQueue<ITransport>>();
    private final Map<String, ConcurrentLinkedQueue<ITransport>> usedResources = new ConcurrentHashMap<String, ConcurrentLinkedQueue<ITransport>>();

    public synchronized ITransport acquire(String alias, Supplier<ITransport> supplier) {
        ConcurrentLinkedQueue availableTransports = this.resources.computeIfAbsent(alias, k -> new ConcurrentLinkedQueue());
        ITransport resource = (ITransport)availableTransports.poll();
        if (resource == null) {
            resource = supplier.get();
        }
        ConcurrentLinkedQueue usedTransports = this.usedResources.computeIfAbsent(alias, k -> new ConcurrentLinkedQueue());
        usedTransports.add(resource);
        return resource;
    }

    public synchronized void release(String alias, ITransport transport) {
        ConcurrentLinkedQueue availableTransports = this.resources.computeIfAbsent(alias, k -> new ConcurrentLinkedQueue());
        ConcurrentLinkedQueue usedTransports = this.usedResources.computeIfAbsent(alias, k -> new ConcurrentLinkedQueue());
        if (usedTransports.contains(transport)) {
            usedTransports.remove(transport);
            availableTransports.add(transport);
        }
    }
}

