/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.object.service;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.persist.PersistService;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import java.lang.annotation.Annotation;
import java.util.Set;
import ru.vyarus.guice.persist.orient.db.scheme.SchemeInitializer;
import ru.vyarus.guice.persist.orient.db.scheme.impl.AutoScanSchemeInitializer;
import ru.vyarus.guice.persist.orient.db.scheme.impl.NoOpSchemeInitializer;
import ru.vyarus.guice.persist.orient.db.scheme.initializer.ObjectSchemeInitializer;
import ru.vyarus.guice.persist.orient.db.scheme.initializer.core.ext.ExtensionsDescriptorFactory;

public class OAutoScanSchemeModule
extends AbstractModule {
    protected void configure() {
        this.requireBinding(PersistService.class);
        Multibinder.newSetBinder((Binder)this.binder(), String.class, (Annotation)Names.named((String)"orient.model.packages"));
        this.bind(ExtensionsDescriptorFactory.class);
    }

    @Provides
    @Singleton
    @Named(value="orient.model.package")
    public String provideOrientModelPackage(@Named(value="orient.model.packages") Set<String> packages) {
        return packages.isEmpty() ? "" : Joiner.on((char)',').join(packages);
    }

    @Provides
    @Singleton
    public SchemeInitializer provideSchemaInitializer(@Named(value="orient.model.package") String appPkgs, Provider<OObjectDatabaseTx> dbProvider, ObjectSchemeInitializer schemeInitializer) {
        if (!Strings.isNullOrEmpty((String)appPkgs)) {
            return new AutoScanSchemeInitializer(appPkgs, dbProvider, schemeInitializer);
        }
        return new NoOpSchemeInitializer();
    }
}

