/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.pivottable.component.widget;

import com.google.inject.Inject;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.encoding.UrlEncoder;
import org.apache.wicket.util.string.Strings;
import org.orienteer.core.behavior.UpdateOnDashboardDisplayModeChangeBehavior;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.service.IOClassIntrospector;
import org.orienteer.core.widget.AbstractWidget;
import org.orienteer.core.widget.Widget;
import org.orienteer.pivottable.component.PivotPanel;

@Widget(id="pivot-table", domain="browse", oClass="PivotTableWidget", order=10, autoEnable=false)
public class BrowsePivotTableWidget
extends AbstractWidget<OClass> {
    private String config;
    private String customSQL;
    private double noCacheRnd = Math.random();
    @Inject
    private IOClassIntrospector oClassIntrospector;

    public BrowsePivotTableWidget(String id, IModel<OClass> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
        this.add(new Component[]{new PivotPanel("pivot", (IModel<String>)new PropertyModel((Object)this, "url"), (IModel<DisplayMode>)new PropertyModel((Object)this, "displayMode"), (IModel<String>)new PropertyModel((Object)this, "config"))});
        this.add(new Behavior[]{UpdateOnDashboardDisplayModeChangeBehavior.INSTANCE});
    }

    public String getUrl() {
        String sql = this.getSql();
        return "/orientdb/query/db/sql/" + UrlEncoder.PATH_INSTANCE.encode(sql, "UTF-8") + "/99999?rnd=" + this.noCacheRnd;
    }

    public String getSql() {
        if (Strings.isEmpty((CharSequence)this.customSQL)) {
            String thisLang = this.getLocale().getLanguage();
            String systemLang = Locale.getDefault().getLanguage();
            OClass oClass = (OClass)this.getModelObject();
            StringBuilder sb = new StringBuilder();
            Collection properties = oClass.properties();
            for (OProperty property : properties) {
                OClass linkedClass;
                OProperty nameProperty;
                OType type = property.getType();
                if (Comparable.class.isAssignableFrom(type.getDefaultJavaType())) {
                    sb.append(property.getName()).append(", ");
                    continue;
                }
                if (!OType.LINK.equals((Object)type) || (nameProperty = this.oClassIntrospector.getNameProperty(linkedClass = property.getLinkedClass())) == null) continue;
                OType linkedClassType = nameProperty.getType();
                String map = property.getName() + '.' + nameProperty.getName();
                if (Comparable.class.isAssignableFrom(linkedClassType.getDefaultJavaType())) {
                    sb.append(map).append(", ");
                    continue;
                }
                if (!OType.EMBEDDEDMAP.equals((Object)linkedClassType)) continue;
                sb.append("coalesce(").append(map).append('[').append(thisLang).append("], ");
                if (!thisLang.equals(systemLang)) {
                    sb.append(map).append('[').append(systemLang).append("], ");
                }
                sb.append("first(").append(map).append(")) as ").append(property.getName()).append(", ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            }
            sb.insert(0, "SELECT ");
            sb.append(" FROM ").append(oClass.getName());
            return sb.toString();
        }
        return this.customSQL;
    }

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.table);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new ResourceModel("widget.pivottable");
    }

    public void loadSettings() {
        super.loadSettings();
        ODocument doc = this.getWidgetDocument();
        if (doc == null) {
            return;
        }
        this.config = (String)doc.field("pivotTableConfiguration");
        this.customSQL = (String)doc.field("sql");
    }

    public void saveSettings() {
        super.saveSettings();
        ODocument doc = this.getWidgetDocument();
        if (doc == null) {
            return;
        }
        doc.field("pivotTableConfiguration", (Object)this.config);
        doc.field("sql", (Object)this.customSQL);
    }

    public DisplayMode getDisplayMode() {
        return this.getDashboardPanel().getModeObject();
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }
}

