/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.pivottable.component;

import de.agilecoders.wicket.webjars.request.resource.WebjarsCssResourceReference;
import de.agilecoders.wicket.webjars.request.resource.WebjarsJavaScriptResourceReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.widget.support.jquery.JQueryDashboardSupport;

public class PivotPanel
extends GenericPanel<String> {
    private static final WebjarsCssResourceReference PIVOT_CSS = new WebjarsCssResourceReference("/webjars/pivottable/current/dist/pivot.min.css");
    private static final WebjarsJavaScriptResourceReference PIVOT_JS = new WebjarsJavaScriptResourceReference("/webjars/pivottable/current/dist/pivot.min.js");
    private static final CssResourceReference PIVOT_CSS_FIX = new CssResourceReference(PivotPanel.class, "pivottable.css");
    private static final WebjarsJavaScriptResourceReference D3_JS = new WebjarsJavaScriptResourceReference("/webjars/d3/current/d3.min.js");
    private static final WebjarsJavaScriptResourceReference D3_RENDERERS_JS = new WebjarsJavaScriptResourceReference("/webjars/pivottable/current/dist/d3_renderers.min.js");
    private static final WebjarsCssResourceReference C3_CSS = new WebjarsCssResourceReference("/webjars/c3/current/c3.min.css");
    private static final WebjarsJavaScriptResourceReference C3_JS = new WebjarsJavaScriptResourceReference("/webjars/c3/current/c3.min.js");
    private static final WebjarsJavaScriptResourceReference C3_RENDERERS_JS = new WebjarsJavaScriptResourceReference("/webjars/pivottable/current/dist/c3_renderers.min.js");
    private static final List<String> SUPPORTED_LANGS = Arrays.asList("en", "es", "fr", "nl", "pt", "ru", "tr", "zh");
    private static final Map<String, WebjarsJavaScriptResourceReference> LANGUAGES_MAP = new HashMap<String, WebjarsJavaScriptResourceReference>();
    private final IModel<String> configModel;
    private final IModel<DisplayMode> modeModel;
    private final UpdatePivotTableBehavior updatePivotTableBehavior;

    public PivotPanel(String id, IModel<String> urlModel, IModel<DisplayMode> modeModel, IModel<String> configModel) {
        super(id, urlModel);
        this.setOutputMarkupId(true);
        this.modeModel = modeModel;
        this.configModel = configModel;
        Behavior[] behaviorArray = new Behavior[1];
        this.updatePivotTableBehavior = new UpdatePivotTableBehavior();
        behaviorArray[0] = this.updatePivotTableBehavior;
        this.add(behaviorArray);
    }

    public void detachModels() {
        super.detachModels();
        this.modeModel.detach();
        this.configModel.detach();
    }

    protected JavaScriptResourceReference getLocalizationJSResource(String lang) {
        if (Strings.isEmpty((CharSequence)lang) || "en".equals(lang)) {
            return null;
        }
        WebjarsJavaScriptResourceReference ret = LANGUAGES_MAP.get(lang);
        if (ret == null) {
            ret = new WebjarsJavaScriptResourceReference("/webjars/pivottable/current/dist/pivot." + lang + ".min.js");
            LANGUAGES_MAP.put(lang, ret);
        }
        return ret;
    }

    public void renderHead(IHeaderResponse response) {
        JavaScriptResourceReference langRes;
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)PIVOT_CSS));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)PIVOT_CSS_FIX));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)C3_CSS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JQueryDashboardSupport.JQUERY_UI_JS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)PIVOT_JS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)D3_JS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)C3_JS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)D3_RENDERERS_JS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)C3_RENDERERS_JS));
        String lang = this.getLocale().getLanguage();
        if (SUPPORTED_LANGS.indexOf(lang) < 0) {
            lang = "en";
        }
        if ((langRes = this.getLocalizationJSResource(lang)) != null) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)langRes));
        }
        PackageTextTemplate template = new PackageTextTemplate(PivotPanel.class, "pivottable.tmpl.js");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("componentId", this.getMarkupId());
        params.put("dataUrl", ((String)this.getModelObject()).replace("'", "\\'"));
        params.put("config", Strings.defaultIfEmpty((String)((String)this.configModel.getObject()), (String)"{}"));
        params.put("editMode", DisplayMode.EDIT.equals(this.modeModel.getObject()));
        params.put("callBackScript", this.updatePivotTableBehavior.getCallbackScript());
        params.put("language", lang);
        template.interpolate(params);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)template.asString()));
    }

    private class UpdatePivotTableBehavior
    extends AbstractDefaultAjaxBehavior {
        private UpdatePivotTableBehavior() {
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.getDynamicExtraParameters().add("return {config: JSON.stringify(cfg)};");
            attributes.setMethod(AjaxRequestAttributes.Method.POST);
        }

        protected void respond(AjaxRequestTarget target) {
            if (PivotPanel.this.configModel != null) {
                PivotPanel.this.configModel.setObject((Object)RequestCycle.get().getRequest().getRequestParameters().getParameterValue("config").toString());
            }
        }

        public boolean isEnabled(Component component) {
            DisplayMode mode = PivotPanel.this.modeModel != null ? (DisplayMode)PivotPanel.this.modeModel.getObject() : DisplayMode.VIEW;
            return DisplayMode.EDIT.equals((Object)mode);
        }
    }
}

