/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.pivottable.component.widget;

import com.orientechnologies.orient.core.record.impl.ODocument;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.encoding.UrlEncoder;
import org.apache.wicket.util.string.Strings;
import org.orienteer.core.behavior.UpdateOnActionPerformedEventBehavior;
import org.orienteer.core.behavior.UpdateOnDashboardDisplayModeChangeBehavior;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.event.ActionPerformedEvent;
import org.orienteer.core.widget.AbstractWidget;
import org.orienteer.pivottable.component.PivotPanel;

public abstract class AbstractPivotTableWidget<T>
extends AbstractWidget<T> {
    private String config;
    private String customSQL;
    private double noCacheRnd = Math.random();

    public AbstractPivotTableWidget(String id, IModel<T> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
        this.add(new Component[]{new PivotPanel("pivot", (IModel<String>)new PropertyModel((Object)this, "url"), (IModel<DisplayMode>)new PropertyModel((Object)this, "displayMode"), (IModel<String>)new PropertyModel((Object)this, "config"))});
        this.add(new Behavior[]{UpdateOnDashboardDisplayModeChangeBehavior.INSTANCE});
        this.add(new Behavior[]{new UpdateOnActionPerformedEventBehavior(false){

            protected void update(Component component, ActionPerformedEvent<?> event, IEvent<?> wicketEvent) {
                AbstractPivotTableWidget.this.noCacheRnd = Math.random();
                super.update(component, event, wicketEvent);
            }

            protected boolean match(Component component, ActionPerformedEvent<?> event, IEvent<?> wicketEvent) {
                return event.getCommand().isChangingModel();
            }
        }});
    }

    public String getUrl() {
        String sql = this.getSql();
        return "/orientdb/query/db/sql/" + UrlEncoder.PATH_INSTANCE.encode(sql, "UTF-8") + "/99999?rnd=" + this.noCacheRnd;
    }

    protected String getSql() {
        String customSql = this.getCustomSql();
        return Strings.isEmpty((CharSequence)customSql) ? this.getDefaultSql() : customSql;
    }

    protected abstract String getDefaultSql();

    protected String getCustomSql() {
        return this.customSQL;
    }

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.table);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new ResourceModel("widget.pivottable");
    }

    public void loadSettings() {
        super.loadSettings();
        ODocument doc = this.getWidgetDocument();
        if (doc == null) {
            return;
        }
        this.config = (String)doc.field("pivotTableConfiguration");
        this.customSQL = (String)doc.field("sql");
    }

    public void saveSettings() {
        super.saveSettings();
        ODocument doc = this.getWidgetDocument();
        if (doc == null) {
            return;
        }
        doc.field("pivotTableConfiguration", (Object)this.config);
        doc.field("sql", (Object)this.customSQL);
    }

    public DisplayMode getDisplayMode() {
        return this.getDashboardPanel().getModeObject();
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }
}

