/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.standalone;

import java.net.URL;
import java.security.ProtectionDomain;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServerRunner {
    public static final int DEFAULT_TIMEOUT = 3600000;
    public static final int DEFAULT_PORT = 8080;
    private String host = null;
    private int port = 8080;
    private int timeout = 3600000;
    private Server server;

    public ServerRunner() {
    }

    public ServerRunner(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public ServerRunner(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public void start() throws Exception {
        if (this.server == null) {
            this.server = new Server();
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(8443);
            httpConfig.setOutputBufferSize(32768);
            ServerConnector http = new ServerConnector(this.server, new HttpConnectionFactory(httpConfig));
            if (this.host != null) {
                http.setHost(this.host);
            }
            http.setPort(8080);
            http.setIdleTimeout(this.timeout);
            this.server.addConnector(http);
            Resource.setDefaultUseCaches(false);
            WebAppContext bb = new WebAppContext();
            bb.setServer(this.server);
            bb.setContextPath("/");
            ProtectionDomain protectionDomain = ServerRunner.class.getProtectionDomain();
            URL location = protectionDomain.getCodeSource().getLocation();
            System.out.println("loading from " + location);
            bb.setWar(location.toExternalForm());
            bb.setExtractWAR(false);
            bb.setCopyWebInf(true);
            bb.setCopyWebDir(false);
            this.server.setHandler(bb);
            this.server.start();
        }
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void join() throws Exception {
        if (this.server != null) {
            this.server.join();
        }
    }
}

