/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.component;

import com.google.inject.Inject;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.validation.EqualPasswordInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.OrienteerFeedbackPanel;
import org.orienteer.core.component.command.AjaxFormCommand;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.service.IOrienteerUsersService;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public class DefaultRestorePasswordPanel
extends GenericPanel<OrienteerUser> {
    @Inject
    private IOrienteerUsersService userService;
    private final IModel<String> passwordModel = Model.of((Serializable)((Object)""));

    public DefaultRestorePasswordPanel(String id, IModel<OrienteerUser> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        Form form = new Form("form");
        PasswordTextField passwordField = new PasswordTextField("password", this.passwordModel);
        PasswordTextField confirmPasswordField = new PasswordTextField("confirmPassword", (IModel)Model.of((Serializable)((Object)"")));
        form.add(new Component[]{passwordField});
        form.add(new Component[]{confirmPasswordField});
        form.add((IFormValidator)new EqualPasswordInputValidator((FormComponent)passwordField, (FormComponent)confirmPasswordField));
        form.add(new Component[]{this.createRestoreButton("restoreButton")});
        this.add(new Component[]{this.createFeedbackPanel("feedback")});
        this.add(new Component[]{form});
        this.setOutputMarkupPlaceholderTag(true);
    }

    protected void onRestore(AjaxRequestTarget target, IModel<OrienteerUser> model) {
    }

    private AjaxFormCommand<Void> createRestoreButton(String id) {
        return new AjaxFormCommand<Void>(id, (IModel)new ResourceModel("panel.restore.button.restore")){

            protected void onInstantiation() {
                super.onInstantiation();
                this.setBootstrapType(BootstrapType.PRIMARY);
            }

            public void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                IModel model = DefaultRestorePasswordPanel.this.getModel();
                DBClosure.sudoConsumer(db -> {
                    OrienteerUser user = (OrienteerUser)((Object)((Object)model.getObject()));
                    String password = (String)DefaultRestorePasswordPanel.this.passwordModel.getObject();
                    user.setPassword(password);
                    user.save();
                    DefaultRestorePasswordPanel.this.userService.clearRestoring(user);
                });
                DefaultRestorePasswordPanel.this.onRestore(target, (IModel<OrienteerUser>)model);
            }
        };
    }

    protected FeedbackPanel createFeedbackPanel(String id) {
        return new OrienteerFeedbackPanel(id);
    }
}

