/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.hook;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.LinkedHashSet;
import java.util.Set;

public class OrienteerUserRoleHook
extends ODocumentHookAbstract {
    public OrienteerUserRoleHook(ODatabaseDocument database) {
        super(database);
        this.setIncludeClasses(new String[]{"ORole"});
    }

    public ORecordHook.RESULT onRecordBeforeCreate(ODocument doc) {
        LinkedHashSet<ODocument> allowRead = (LinkedHashSet<ODocument>)doc.field(ORestrictedOperation.ALLOW_READ.getFieldName(), Set.class);
        if (allowRead == null || !allowRead.contains(doc)) {
            allowRead = allowRead != null ? new LinkedHashSet<ODocument>(allowRead) : new LinkedHashSet();
            allowRead.add(doc);
            doc.field(ORestrictedOperation.ALLOW_READ.getFieldName(), allowRead);
            return ORecordHook.RESULT.RECORD_CHANGED;
        }
        return super.onRecordBeforeCreate(doc);
    }

    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.SOURCE_NODE;
    }
}

