/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.module;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibrary;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.orienteer.core.CustomAttribute;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.module.AbstractOrienteerModule;
import org.orienteer.core.util.OSchemaHelper;
import org.orienteer.users.hook.OrienteerUserHook;
import org.orienteer.users.hook.OrienteerUserRoleHook;
import org.orienteer.users.resource.RegistrationResource;
import org.orienteer.users.resource.RestorePasswordResource;
import org.orienteer.users.util.OUsersCommonUtils;
import ru.ydn.wicket.wicketorientdb.security.OSecurityHelper;
import ru.ydn.wicket.wicketorientdb.security.OrientPermission;

public class OrienteerUsersModule
extends AbstractOrienteerModule {
    public static final String ORIENTEER_USER_ROLE = "orienteerUser";
    public static final String ORIENTEER_USER_PERSPECTIVE = "orienteerUserPerspective";
    public static final String READER_PERSPECTIVE = "readerPerspective";
    public static final String EVENT_RESTORE_PASSWORD_PREFIX = "removeUserRestoreId";
    public static final String FUN_REMOVE_RESTORE_ID = "removeRestoreId";
    public static final String PARAM_RESTORE_ID = "restoreId";
    public static final String PARAM_EVENT_NAME = "eventName";
    public static final String PARAM_TIMEOUT = "timeout";
    public static final String MODULE_NAME = "orienteer-users";
    public static final CustomAttribute REMOVE_CRON_RULE = CustomAttribute.create((String)"remove.cron", (OType)OType.STRING, (Object)"", (boolean)false, (boolean)false);
    public static final CustomAttribute REMOVE_SCHEDULE_START_TIMEOUT = CustomAttribute.create((String)"remove.timeout", (OType)OType.STRING, (Object)"0", (boolean)false, (boolean)false);
    public static final String MAIL_RESTORE = "restore";
    public static final String MAIL_REGISTRATION = "registration";
    public static final String MAIL_MACROS_LINK = "link";

    protected OrienteerUsersModule() {
        super(MODULE_NAME, 1, new String[]{"perspectives", "orienteer-mail"});
    }

    public ODocument onInstall(OrienteerWebApplication app, ODatabaseDocument db) {
        OSchemaHelper helper = OSchemaHelper.bind((ODatabaseDocument)db);
        OClass user = helper.oClass("OUser", new String[0]).oProperty("id", OType.STRING).notNull().updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)true).oProperty(PARAM_RESTORE_ID, OType.STRING).updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)true).updateCustomAttribute(REMOVE_CRON_RULE, (Object)"0 0/1 * * * ?").updateCustomAttribute(REMOVE_SCHEDULE_START_TIMEOUT, (Object)"86400000").oProperty("restoreIdCreated", OType.DATETIME).updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)true).oProperty("email", OType.STRING).notNull().oProperty("firstName", OType.STRING).oProperty("lastName", OType.STRING).getOClass();
        this.updateDefaultOrienteerUsers(db);
        helper.oIndex(user.getProperty("id").getFullName(), OClass.INDEX_TYPE.UNIQUE, new String[]{"id"});
        helper.oIndex(user.getProperty("email").getFullName(), OClass.INDEX_TYPE.UNIQUE, new String[]{"email"});
        OUsersCommonUtils.setRestricted(db, helper.oClass("OIdentity", new String[0]).getOClass());
        OUsersCommonUtils.setRestricted(db, helper.oClass("OPerspective", new String[0]).getOClass());
        ODocument perspective = this.createOrienteerUsersPerspective(db);
        ODocument readerPerspective = this.createReaderPespective(db);
        ODocument reader = this.updateAndGetUserReader(db);
        this.updateReaderPermissions(db, reader, readerPerspective);
        this.updateOrienteerUserRoleDoc(db, perspective);
        this.createRemoveRestoreIdFunction(helper);
        return null;
    }

    private void updateOrienteerUserRoleDoc(ODatabaseDocument db, ODocument perspective) {
        OSecurity security = db.getMetadata().getSecurity();
        ORole role = security.getRole(ORIENTEER_USER_ROLE);
        if (role == null) {
            ORole reader = security.getRole("reader");
            role = security.createRole(ORIENTEER_USER_ROLE, reader, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        }
        role.grant(ORule.ResourceGeneric.CLASS, "OWidget", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "ODashboard", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "OPerspectiveItem", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "OPerspective", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "ORole", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.SCHEMA, null, OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLUSTER, "internal", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.RECORD_HOOK, "", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.DATABASE, null, OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.DATABASE, "systemclusters", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.DATABASE, "function", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.DATABASE, "command", OrientPermission.READ.getPermissionFlag());
        role.grant(OSecurityHelper.FEATURE_RESOURCE, "search", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "OUser", OrientPermission.combinedPermission((OrientPermission[])new OrientPermission[]{OrientPermission.READ, OrientPermission.UPDATE}));
        role.grant(ORule.ResourceGeneric.DATABASE, "cluster", OrientPermission.combinedPermission((OrientPermission[])new OrientPermission[]{OrientPermission.READ, OrientPermission.UPDATE}));
        role.getDocument().field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singletonList(role.getDocument()));
        role.getDocument().field("perspective", (Object)perspective);
        role.save();
        perspective.field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singletonList(role.getDocument()));
        perspective.save();
    }

    private void updateReaderPermissions(ODatabaseDocument db, ODocument reader, ODocument perspective) {
        ORole role = db.getMetadata().getSecurity().getRole("reader");
        role.grant(ORule.ResourceGeneric.CLASS, "OPerspectiveItem", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "OPerspective", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, null, 0);
        role.grant(ORule.ResourceGeneric.CLASS, "ORole", OrientPermission.READ.getPermissionFlag());
        role.grant(OSecurityHelper.FEATURE_RESOURCE, "search", 0);
        role.grant(OSecurityHelper.FEATURE_RESOURCE, "schema", 0);
        role.getDocument().field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singletonList(reader));
        role.getDocument().field("perspective", (Object)perspective);
        role.save();
        perspective.field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singleton(role.getDocument()));
        perspective.save();
    }

    private ODocument createOrienteerUsersPerspective(ODatabaseDocument db) {
        ODocument perspective = OUsersCommonUtils.getOrCreatePerspective(db, ORIENTEER_USER_PERSPECTIVE);
        perspective.field("icon", (Object)FAIconType.user_o.name());
        perspective.field("homeUrl", (Object)"/browse/OUser");
        perspective.save();
        ODocument item1 = OUsersCommonUtils.getOrCreatePerspectiveItem(db, perspective, "perspective.menu.item.profile");
        item1.field("icon", (Object)FAIconType.user_o.name());
        item1.field("perspective", (Object)perspective);
        item1.field("url", (Object)"/browse/OUser");
        item1.save();
        perspective.save();
        return perspective;
    }

    private ODocument createReaderPespective(ODatabaseDocument db) {
        ODocument perspective = OUsersCommonUtils.getOrCreatePerspective(db, READER_PERSPECTIVE);
        perspective.field("icon", (Object)FAIconType.database.name());
        perspective.field("homeUrl", (Object)"/browse/OUser");
        perspective.save();
        return perspective;
    }

    private ODocument updateAndGetUserReader(ODatabaseDocument db) {
        String sql = String.format("select from %s where name = ?", "OUser");
        List docs = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{"reader"});
        ODocument reader = (ODocument)docs.get(0);
        Set users = (Set)reader.field(ORestrictedOperation.ALLOW_READ.getFieldName(), Set.class);
        if (users == null || users.isEmpty()) {
            reader.field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singleton(reader));
        } else {
            users.add(reader);
            reader.field(ORestrictedOperation.ALLOW_READ.getFieldName(), (Object)users);
        }
        reader.save();
        return reader;
    }

    private void createRemoveRestoreIdFunction(OSchemaHelper helper) {
        OFunctionLibrary lib = helper.getDatabase().getMetadata().getFunctionLibrary();
        if (lib.getFunction(FUN_REMOVE_RESTORE_ID) != null) {
            lib.dropFunction(FUN_REMOVE_RESTORE_ID);
        }
        OFunction function = lib.createFunction(FUN_REMOVE_RESTORE_ID);
        function.setName(FUN_REMOVE_RESTORE_ID);
        function.setLanguage("javascript");
        function.setCode(this.createCodeForRemoveRestoreIdFunction());
        function.setParameters(this.createParamsForRemoveRestoreIdFunction());
        function.save();
    }

    private String createCodeForRemoveRestoreIdFunction() {
        return String.format("var res = db.command('UPDATE %s SET %s = null, %s = null WHERE %s = ? AND %s <= (sysdate() - ?)', %s, %s);\nif (res > 0) db.command('DELETE FROM OSchedule WHERE name = ?', %s);", "OUser", PARAM_RESTORE_ID, "restoreIdCreated", PARAM_RESTORE_ID, "restoreIdCreated", PARAM_RESTORE_ID, PARAM_TIMEOUT, PARAM_EVENT_NAME);
    }

    private List<String> createParamsForRemoveRestoreIdFunction() {
        LinkedList<String> params = new LinkedList<String>();
        params.add(PARAM_RESTORE_ID);
        params.add(PARAM_EVENT_NAME);
        params.add(PARAM_TIMEOUT);
        return params;
    }

    private void updateDefaultOrienteerUsers(ODatabaseDocument db) {
        OSecurity security = db.getMetadata().getSecurity();
        ODocument admin = security.getUser("admin").getDocument();
        admin.field("id", (Object)UUID.randomUUID().toString());
        admin.field("email", (Object)"admin@gmail.com");
        admin.save();
        ODocument reader = security.getUser("reader").getDocument();
        reader.field("id", (Object)UUID.randomUUID().toString());
        reader.field("email", (Object)"reader@gmail.com");
        reader.save();
        ODocument writer = security.getUser("writer").getDocument();
        writer.field("id", (Object)UUID.randomUUID().toString());
        writer.field("email", (Object)"writer@gmail.com");
        writer.save();
    }

    public void onUpdate(OrienteerWebApplication app, ODatabaseDocument db, int oldVersion, int newVersion) {
        this.onInstall(app, db);
    }

    public void onInitialize(OrienteerWebApplication app, ODatabaseDocument db) {
        List hooks = app.getOrientDbSettings().getORecordHooks();
        hooks.add(OrienteerUserHook.class);
        hooks.add(OrienteerUserRoleHook.class);
        RegistrationResource.mount(app);
        RestorePasswordResource.mount(app);
        app.mountPages("org.orienteer.users.web");
        OScheduler scheduler = db.getMetadata().getScheduler();
        Collection events = scheduler.getEvents().values();
        for (OScheduledEvent event : events) {
            scheduler.updateEvent(event);
        }
    }

    public void onDestroy(OrienteerWebApplication app, ODatabaseDocument db) {
        List hooks = app.getOrientDbSettings().getORecordHooks();
        hooks.remove(OrienteerUserHook.class);
        hooks.remove(OrienteerUserRoleHook.class);
        RegistrationResource.unmount(app);
        RestorePasswordResource.unmount(app);
        app.unmountPages("org.orienteer.users.web");
    }
}

