/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.resource;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.io.IOException;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.SharedResourceReference;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.web.LoginPage;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.service.IOrienteerUsersService;
import org.orienteer.users.util.OUsersDbUtils;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public class RegistrationResource
extends AbstractResource {
    public static final String MOUNT_PATH = "/r/registration";
    public static final String RES_KEY = RegistrationResource.class.getName();
    public static final String PARAMETER_ID = "id";
    @Inject
    private IOrienteerUsersService service;

    public static String createRegistrationLink(OrienteerUser user) {
        PageParameters params = new PageParameters();
        params.add(PARAMETER_ID, (Object)user.getId());
        CharSequence url = RequestCycle.get().urlFor((ResourceReference)new SharedResourceReference(RES_KEY), params);
        return RequestCycle.get().getUrlRenderer().renderFullUrl(Url.parse((CharSequence)url));
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attrs) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        if (response.dataNeedsToBeWritten(attrs)) {
            PageParameters params = attrs.getParameters();
            String id = params.get(PARAMETER_ID).toOptionalString();
            if (!Strings.isNullOrEmpty((String)id)) {
                OUsersDbUtils.getUserById(id).filter(user -> user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE).ifPresent(user -> {
                    user.setAccountStatus(OSecurityUser.STATUSES.ACTIVE);
                    DBClosure.sudoSave((ODocumentWrapper[])new ODocumentWrapper[]{user});
                    response.setWriteCallback(this.createCallback(true));
                });
            }
            if (response.getWriteCallback() == null) {
                response.setWriteCallback(this.createCallback(false));
            }
        }
        return response;
    }

    private AbstractResource.WriteCallback createCallback(final boolean success) {
        return new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                PageParameters params = new PageParameters();
                if (success) {
                    params.set(RegistrationResource.PARAMETER_ID, (Object)attributes.getParameters().get(RegistrationResource.PARAMETER_ID).toOptionalString());
                }
                RequestCycle.get().setResponsePage(LoginPage.class, params);
            }
        };
    }

    public static void mount(OrienteerWebApplication app) {
        RegistrationResource resource = (RegistrationResource)((Object)app.getServiceInstance(RegistrationResource.class));
        app.getSharedResources().add(RES_KEY, (IResource)resource);
        app.mountResource(MOUNT_PATH, (ResourceReference)new SharedResourceReference(RES_KEY));
    }

    public static void unmount(OrienteerWebApplication app) {
        app.getSharedResources().remove(app.getSharedResources().get(RES_KEY).getKey());
        app.unmount(MOUNT_PATH);
    }
}

