/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.util;

import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.util.CommonUtils;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.util.OUsersCommonUtils;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public final class OUsersDbUtils {
    private OUsersDbUtils() {
    }

    public static Optional<ODocument> getDefaultOrienteerUserPerspective() {
        return (Optional)DBClosure.sudo(db -> {
            String sql = String.format("select from %s where name.en = ?", "OPerspective");
            String name = OUsersCommonUtils.getString(OrienteerWebApplication.lookupApplication(), "orienteerUserPerspective", Locale.ENGLISH);
            List identifiables = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{name});
            return CommonUtils.getDocument((List)identifiables);
        });
    }

    public static Optional<ORole> getRoleByName(String name) {
        return (Optional)DBClosure.sudo(db -> Optional.ofNullable(db.getMetadata().getSecurity().getRole(name)));
    }

    public static Optional<OrienteerUser> getUserByRestoreId(String restoreId) {
        return OUsersDbUtils.getUserBy("restoreId", restoreId);
    }

    public static Optional<OrienteerUser> getUserById(String id) {
        return OUsersDbUtils.getUserBy("id", id);
    }

    public static Optional<OrienteerUser> getUserByEmail(String email) {
        return OUsersDbUtils.getUserBy("email", email);
    }

    public static boolean isUserExistsWithRestoreId(String restoreId) {
        return OUsersDbUtils.isUserExistsBy("restoreId", restoreId);
    }

    public static boolean isUserExistsWithEmail(String email) {
        return OUsersDbUtils.isUserExistsBy("email", email);
    }

    public static boolean isUserExistsWithId(String id) {
        return OUsersDbUtils.isUserExistsBy("id", id);
    }

    private static Optional<OrienteerUser> getUserBy(String field, String value) {
        return (Optional)DBClosure.sudo(db -> {
            String sql = String.format("select from %s where %s = ?", "OUser", field);
            List identifiables = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{value});
            return CommonUtils.getFromIdentifiables((List)identifiables, OrienteerUser::new);
        });
    }

    private static boolean isUserExistsBy(String field, String value) {
        return (Boolean)DBClosure.sudo(db -> {
            String sql = String.format("select count(*) from %s where %s = ?", "OUser", field);
            List documents = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{value});
            return CommonUtils.getDocument((List)documents).map(d -> (Long)d.field("count") == 1L).orElse(false);
        });
    }
}

