/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.web;

import com.google.inject.Inject;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.orienteer.core.MountPath;
import org.orienteer.core.OrienteerWebSession;
import org.orienteer.core.web.BasePage;
import org.orienteer.core.web.HomePage;
import org.orienteer.users.component.DefaultRegistrationPanel;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.service.IOrienteerUsersService;
import ru.ydn.wicket.wicketorientdb.model.ODocumentWrapperModel;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

@MountPath(value="/register")
public class DefaultRegistrationPage
extends BasePage<OrienteerUser> {
    @Inject
    private IOrienteerUsersService service;
    private WebMarkupContainer container;

    public DefaultRegistrationPage() {
        this.setModel((IModel)new ODocumentWrapperModel((ODocumentWrapper)this.service.createUser()));
    }

    public DefaultRegistrationPage(PageParameters parameters) {
        super(parameters);
        this.setModel((IModel)new ODocumentWrapperModel((ODocumentWrapper)this.service.createUser()));
    }

    protected void onInitialize() {
        super.onInitialize();
        if (OrienteerWebSession.get().getUser() != null) {
            this.setResponsePage(HomePage.class);
        }
        Component[] componentArray = new Component[1];
        this.container = this.createContainer("container");
        componentArray[0] = this.container;
        this.add(componentArray);
        this.add(new Component[]{new Label("registrationTitle", this.getRegistrationTitleModel())});
    }

    private WebMarkupContainer createContainer(String id) {
        return new WebMarkupContainer(id){

            protected void onInitialize() {
                super.onInitialize();
                this.add(new Component[]{DefaultRegistrationPage.this.createRegistrationPanel("registrationPanel")});
                this.add(new Component[]{DefaultRegistrationPage.this.createRegistrationSuccessLabel("registrationSuccessLabel")});
                this.setOutputMarkupPlaceholderTag(true);
            }
        };
    }

    protected GenericPanel<OrienteerUser> createRegistrationPanel(String id) {
        return new DefaultRegistrationPanel(id, this.getModel()){

            @Override
            protected void onRegister(AjaxRequestTarget target, IModel<OrienteerUser> model) {
                OrienteerUser user = (OrienteerUser)((Object)model.getObject());
                DBClosure.sudoSave((ODocumentWrapper[])new ODocumentWrapper[]{user});
                DefaultRegistrationPage.this.service.notifyUserAboutRegistration(user);
                target.add(new Component[]{DefaultRegistrationPage.this.container});
            }

            protected void onConfigure() {
                OrienteerUser user = (OrienteerUser)((Object)this.getModelObject());
                this.setVisible(!user.getDocument().getIdentity().isValid());
                super.onConfigure();
            }
        };
    }

    protected IModel<String> getRegistrationTitleModel() {
        return new ResourceModel("page.registration.title");
    }

    protected Label createRegistrationSuccessLabel(String id) {
        return new Label(id, (IModel)new ResourceModel("page.registration.success")){

            protected void onConfigure() {
                super.onConfigure();
                OrienteerUser user = (OrienteerUser)((Object)DefaultRegistrationPage.this.getModelObject());
                this.setVisible(user.getDocument().getIdentity().isValid());
            }
        };
    }

    public IModel<String> getTitleModel() {
        return new ResourceModel("page.registration.page.title");
    }

    protected String getBodyAppSubClasses() {
        return "flex-row align-items-center footer-fixed";
    }
}

