/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.component;

import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.EmailTextField;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.EqualPasswordInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.OrienteerFeedbackPanel;
import org.orienteer.core.component.command.AjaxFormCommand;
import org.orienteer.users.component.SocialNetworkPanel;
import org.orienteer.users.model.OAuth2Service;
import org.orienteer.users.model.OAuth2ServiceContext;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.repository.OAuth2Repository;
import org.orienteer.users.validation.UserEmailValidator;

public class DefaultRegistrationPanel
extends GenericPanel<OrienteerUser> {
    private final IModel<String> passwordModel = Model.of();

    public DefaultRegistrationPanel(String id, IModel<OrienteerUser> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        IModel model = this.getModel();
        Form form = new Form("form");
        form.add(new Component[]{new TextField("firstName", (IModel)new PropertyModel((Object)model, "firstName")).setRequired(true)});
        form.add(new Component[]{new TextField("lastName", (IModel)new PropertyModel((Object)model, "lastName")).setRequired(true)});
        form.add(new Component[]{this.createEmailField("email", (IModel<String>)new PropertyModel((Object)model, "email"))});
        PasswordTextField passwordField = new PasswordTextField("password", this.passwordModel);
        PasswordTextField confirmPasswordField = new PasswordTextField("confirmPassword", (IModel)Model.of((Serializable)((Object)"")));
        form.add(new Component[]{passwordField});
        form.add(new Component[]{confirmPasswordField});
        form.add((IFormValidator)new EqualPasswordInputValidator((FormComponent)passwordField, (FormComponent)confirmPasswordField));
        form.add(new Component[]{this.createRegisterButton("registerButton")});
        form.add(new Component[]{this.createSocialNetworksPanel("socialNetworks")});
        this.add(new Component[]{form});
        this.add(new Component[]{this.createFeedbackPanel("feedback")});
        this.setOutputMarkupPlaceholderTag(true);
    }

    private Panel createSocialNetworksPanel(String id) {
        List<OAuth2Service> services = OAuth2Repository.getOAuth2Services(true);
        if (services.isEmpty()) {
            return new EmptyPanel(id);
        }
        return new SocialNetworkPanel(id, "panel.registration.social.networks.title", (IModel)new ListModel(services)){

            @Override
            protected OAuth2ServiceContext createOAuth2ServiceContext(OAuth2Service service) {
                OAuth2ServiceContext ctx = super.createOAuth2ServiceContext(service);
                ctx.setRegistration(true);
                return ctx;
            }
        };
    }

    protected void onRegister(AjaxRequestTarget target, IModel<OrienteerUser> model) {
    }

    private EmailTextField createEmailField(String id, IModel<String> model) {
        EmailTextField field = new EmailTextField(id, model);
        field.setRequired(true);
        field.add((IValidator)new UserEmailValidator());
        return field;
    }

    private AjaxFormCommand<Void> createRegisterButton(String id) {
        return new AjaxFormCommand<Void>(id, "panel.registration.button.register"){

            protected void onInstantiation() {
                super.onInstantiation();
                this.setBootstrapType(BootstrapType.PRIMARY);
            }

            public void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                OrienteerUser user = (OrienteerUser)((Object)DefaultRegistrationPanel.this.getModelObject());
                user.setName(user.getEmail());
                user.setPassword((String)DefaultRegistrationPanel.this.passwordModel.getObject());
                user.setAccountStatus(OSecurityUser.STATUSES.SUSPENDED);
                DefaultRegistrationPanel.this.onRegister(target, (IModel<OrienteerUser>)DefaultRegistrationPanel.this.getModel());
            }
        };
    }

    protected FeedbackPanel createFeedbackPanel(String id) {
        return new OrienteerFeedbackPanel(id);
    }
}

