/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.component;

import com.google.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.EmailTextField;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.command.AjaxFormCommand;
import org.orienteer.users.component.event.RestorePasswordEventPayload;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.repository.OrienteerUserRepository;
import org.orienteer.users.service.IOrienteerUsersService;

public class RestorePasswordPanel
extends GenericPanel<Boolean> {
    private final IModel<String> emailModel = Model.of();
    @Inject
    private IOrienteerUsersService usersService;

    public RestorePasswordPanel(String id, IModel<Boolean> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        Form form = new Form("form");
        form.add(new Component[]{this.createEmailTextField("email")});
        form.add(new Component[]{this.createRestorePasswordButton("restorePasswordButton")});
        form.add(new Component[]{this.createLoginLink("loginLink")});
        this.add(new Component[]{form});
        this.setOutputMarkupPlaceholderTag(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        Boolean restore = (Boolean)this.getModelObject();
        this.setVisible(restore != null && restore != false);
    }

    private TextField<String> createEmailTextField(String id) {
        EmailTextField emailTextField = new EmailTextField(id, this.emailModel);
        emailTextField.setRequired(true);
        return emailTextField;
    }

    private AjaxFormCommand<Void> createRestorePasswordButton(String id) {
        return new AjaxFormCommand<Void>(id, (IModel)new ResourceModel("panel.restore.password.button.restore")){

            protected void onInstantiation() {
                super.onInstantiation();
                this.setBootstrapType(BootstrapType.PRIMARY);
            }

            public void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                OrienteerUserRepository.getUserByEmail((String)RestorePasswordPanel.this.emailModel.getObject()).ifPresent(user -> RestorePasswordPanel.this.usersService.restoreUserPassword((OrienteerUser)((Object)user)));
                RestorePasswordPanel.this.emailModel.setObject(null);
                this.send((IEventSink)this.getParent(), Broadcast.BUBBLE, new RestorePasswordEventPayload(target, false));
            }
        };
    }

    private AjaxLink<Void> createLoginLink(String id) {
        return new AjaxLink<Void>(id){

            public void onClick(AjaxRequestTarget target) {
                RestorePasswordPanel.this.emailModel.setObject(null);
                this.send((IEventSink)this.getParent(), Broadcast.BUBBLE, new RestorePasswordEventPayload(target, false));
            }
        };
    }
}

