/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.component;

import com.google.inject.Inject;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.flow.RedirectToUrlException;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.orienteer.users.model.IOAuth2Provider;
import org.orienteer.users.model.OAuth2Service;
import org.orienteer.users.model.OAuth2ServiceContext;
import org.orienteer.users.service.IOAuth2Service;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public class SocialNetworkPanel
extends GenericPanel<List<OAuth2Service>> {
    public static final CssResourceReference CSS_STYLE = new CssResourceReference(SocialNetworkPanel.class, "style.css");
    @Inject
    private IOAuth2Service auth2Service;
    private final String titleKey;

    public SocialNetworkPanel(String id, String titleKey, IModel<List<OAuth2Service>> model) {
        super(id, model);
        this.titleKey = titleKey;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (IModel)new ResourceModel(this.titleKey))});
        this.add(new Component[]{this.createSocialNetworksServices("networks")});
        this.setOutputMarkupPlaceholderTag(true);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)CSS_STYLE));
    }

    protected void onSocialImageClick(AjaxRequestTarget target, IModel<OAuth2Service> model) {
        OAuth2Service service = (OAuth2Service)((Object)model.getObject());
        OAuth2ServiceContext ctx = this.createOAuth2ServiceContext(service);
        DBClosure.sudoConsumer(db -> ctx.save());
        throw new RedirectToUrlException(ctx.getAuthorizationUrl());
    }

    protected OAuth2ServiceContext createOAuth2ServiceContext(OAuth2Service service) {
        return this.auth2Service.requestAuthorizationUrl(service, UUID.randomUUID().toString());
    }

    private ListView<OAuth2Service> createSocialNetworksServices(String id) {
        return new ListView<OAuth2Service>(id, this.getModel()){

            protected void populateItem(final ListItem<OAuth2Service> item) {
                IOAuth2Provider provider = ((OAuth2Service)((Object)item.getModelObject())).getProvider();
                Image image = new Image("networkImage", provider.getIconResourceReference(), new ResourceReference[0]);
                image.setOutputMarkupPlaceholderTag(true);
                image.add(new Behavior[]{new AjaxEventBehavior("click"){

                    protected void onEvent(AjaxRequestTarget target) {
                        SocialNetworkPanel.this.onSocialImageClick(target, (IModel<OAuth2Service>)item.getModel());
                    }
                }});
                image.add(new Behavior[]{new AttributeModifier("alt", (Serializable)((Object)new ResourceModel(provider.getLabel()).getObject()))});
                item.add(new Component[]{image});
            }

            protected void onInitialize() {
                super.onInitialize();
                this.setReuseItems(true);
            }
        };
    }
}

