/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.component.panel;

import com.google.inject.Inject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.MapModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.orienteer.users.component.SocialNetworkPanel;
import org.orienteer.users.model.IOAuth2Provider;
import org.orienteer.users.model.OAuth2Service;
import org.orienteer.users.model.OAuth2ServiceContext;
import org.orienteer.users.model.OUserSocialNetwork;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.repository.OAuth2Repository;
import org.orienteer.users.service.IOAuth2Service;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public class LinkToSocialNetworkPanel
extends GenericPanel<OrienteerUser> {
    @Inject
    private IOAuth2Service auth2Service;
    private Label feedbackLabel;

    public LinkToSocialNetworkPanel(String id, IModel<OrienteerUser> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createSocialNetworksServices("networks")});
        Component[] componentArray = new Component[1];
        this.feedbackLabel = new Label("feedback");
        componentArray[0] = this.feedbackLabel;
        this.add(componentArray);
        this.feedbackLabel.setOutputMarkupPlaceholderTag(true);
        this.feedbackLabel.setVisible(false);
        this.setOutputMarkupPlaceholderTag(true);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)SocialNetworkPanel.CSS_STYLE));
    }

    private void onSocialImageClick(AjaxRequestTarget target, IModel<OAuth2Service> model) {
        OAuth2Service service = (OAuth2Service)((Object)model.getObject());
        OAuth2ServiceContext ctx = this.createOAuth2ServiceContext(service);
        ctx.setSocialNetworkLink(true);
        DBClosure.sudoConsumer(db -> ctx.save());
        String url = ctx.getAuthorizationUrl();
        target.appendJavaScript((CharSequence)String.format("window.open('%s', '_blank', 'height=570,width=520')", url));
        HashMap<String, String> macros = new HashMap<String, String>();
        macros.put("network", new ResourceModel(service.getProvider().getLabel()).getObject());
        this.feedbackLabel.setDefaultModel((IModel)new StringResourceModel("info.social.network.added", (IModel)new MapModel(macros)));
        this.feedbackLabel.setVisible(true);
        target.add(new Component[]{this.feedbackLabel});
    }

    private OAuth2ServiceContext createOAuth2ServiceContext(OAuth2Service service) {
        return this.auth2Service.requestAuthorizationUrl(service, UUID.randomUUID().toString());
    }

    private ListView<OAuth2Service> createSocialNetworksServices(String id) {
        return new ListView<OAuth2Service>(id, this.resolveNotLinkedOAuth2Services((OrienteerUser)((Object)this.getModelObject()))){

            protected void onConfigure() {
                super.onConfigure();
                this.setModelObject(LinkToSocialNetworkPanel.this.resolveNotLinkedOAuth2Services((OrienteerUser)((Object)LinkToSocialNetworkPanel.this.getModelObject())));
            }

            protected void populateItem(final ListItem<OAuth2Service> item) {
                IOAuth2Provider provider = ((OAuth2Service)((Object)item.getModelObject())).getProvider();
                final Image image = new Image("networkImage", provider.getIconResourceReference(), new ResourceReference[0]);
                image.setOutputMarkupPlaceholderTag(true);
                image.add(new Behavior[]{new AjaxEventBehavior("click"){

                    protected void onEvent(AjaxRequestTarget target) {
                        LinkToSocialNetworkPanel.this.onSocialImageClick(target, (IModel<OAuth2Service>)item.getModel());
                        image.setVisible(false);
                        target.add(new Component[]{image});
                    }
                }});
                image.add(new Behavior[]{new AttributeModifier("alt", (Serializable)((Object)new ResourceModel(provider.getLabel()).getObject()))});
                item.add(new Component[]{image});
            }

            protected void onInitialize() {
                super.onInitialize();
                this.setReuseItems(true);
            }
        };
    }

    private List<OAuth2Service> resolveNotLinkedOAuth2Services(OrienteerUser user) {
        List<OAuth2Service> activeServices = OAuth2Repository.getOAuth2Services(true);
        List usedServices = user.getSocialNetworks().stream().map(OUserSocialNetwork::getService).collect(Collectors.toCollection(LinkedList::new));
        return activeServices.stream().filter(service -> !usedServices.contains(service)).collect(Collectors.toCollection(LinkedList::new));
    }
}

