/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.component.visualizer;

import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.visualizer.AbstractSimpleVisualizer;
import org.orienteer.users.model.IOAuth2Provider;
import org.orienteer.users.model.OAuth2Provider;
import org.orienteer.users.util.OAuth2ProviderChoiceProvider;
import org.orienteer.users.util.OUsersCommonUtils;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Select2Choice;

public class OAuth2ProviderVisualizer
extends AbstractSimpleVisualizer {
    public static final String NAME = "oauth2-visualizer";

    public OAuth2ProviderVisualizer() {
        this(NAME);
    }

    protected OAuth2ProviderVisualizer(String name) {
        super(name, false, new OType[]{OType.STRING});
    }

    public <V> Component createComponent(String id, DisplayMode mode, IModel<ODocument> documentModel, IModel<OProperty> propertyModel, IModel<V> valueModel) {
        if (mode == DisplayMode.EDIT) {
            return new Select2Choice(id, valueModel, this.createProvider());
        }
        return new Label(id, valueModel){

            public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                String name = (String)this.getDefaultModelObject();
                IOAuth2Provider provider = OAuth2ProviderVisualizer.this.getProviderByName(name);
                String label = (String)OAuth2ProviderVisualizer.this.createProviderLabelModel(provider).getObject();
                this.replaceComponentTagBody(markupStream, openTag, label);
            }
        };
    }

    protected ChoiceProvider<String> createProvider() {
        List<IOAuth2Provider> providers = OUsersCommonUtils.getOAuth2Providers();
        return new OAuth2ProviderChoiceProvider(providers);
    }

    protected IOAuth2Provider getProviderByName(String name) {
        return OAuth2Provider.valueOf(name);
    }

    protected IModel<String> createProviderLabelModel(IOAuth2Provider provider) {
        return new ResourceModel(provider.getLabel());
    }
}

