/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.hook;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.orienteer.users.repository.OrienteerUserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrienteerUserHook
extends ODocumentHookAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(OrienteerUserHook.class);

    public OrienteerUserHook(ODatabaseDocument database) {
        super(database);
        this.setIncludeClasses(new String[]{"OUser"});
    }

    public ORecordHook.RESULT onRecordBeforeCreate(ODocument doc) {
        if (doc.field("id") == null) {
            doc.field("id", (Object)UUID.randomUUID().toString());
        }
        if (doc.field("perspective") == null) {
            OrienteerUserRepository.getDefaultOrienteerUserPerspective().ifPresent(perspective -> doc.field("perspective", perspective));
        }
        ODocument orienteerRole = this.getOrienteerUserRole();
        List roles = (List)doc.field("roles", List.class);
        if (roles == null || roles.isEmpty()) {
            doc.field("roles", Collections.singleton(orienteerRole));
        }
        this.updateAllowPermissions(ORestrictedOperation.ALLOW_READ.getFieldName(), doc);
        this.updateAllowPermissions(ORestrictedOperation.ALLOW_UPDATE.getFieldName(), doc);
        return ORecordHook.RESULT.RECORD_CHANGED;
    }

    private void updateAllowPermissions(String field, ODocument user) {
        LinkedList<Object> allows = (LinkedList<ODocument>)user.field(field, List.class);
        allows = allows == null ? new LinkedList<ODocument>() : new LinkedList(allows);
        allows.add(user);
        user.field(field, allows);
    }

    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.SOURCE_NODE;
    }

    private ODocument getOrienteerUserRole() {
        return OrienteerUserRepository.getRoleByName("orienteerUser").map(ODocumentWrapper::getDocument).orElseThrow(() -> new IllegalStateException("Role orienteerUser not exists"));
    }
}

