/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.model;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import org.orienteer.users.model.IOAuth2Provider;
import org.orienteer.users.model.OAuth2Provider;
import org.orienteer.users.module.OrienteerUsersModule;
import org.orienteer.users.repository.OrienteerUserModuleRepository;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public class OAuth2Service
extends ODocumentWrapper {
    public static final String CLASS_NAME = "OAuth2Service";
    public static final String PROP_API_KEY = "apiKey";
    public static final String PROP_API_SECRET = "apiSecret";
    public static final String PROP_PROVIDER = "provider";
    public static final String PROP_ACTIVE = "active";

    public OAuth2Service() {
        this(CLASS_NAME);
    }

    public OAuth2Service(String iClassName) {
        super(iClassName);
    }

    public OAuth2Service(ODocument iDocument) {
        super(iDocument);
    }

    public String getApiKey() {
        return (String)this.document.field(PROP_API_KEY);
    }

    public OAuth2Service setApiKey(String key) {
        this.document.field(PROP_API_KEY, (Object)key);
        return this;
    }

    public String getApiSecret() {
        return (String)this.document.field(PROP_API_SECRET);
    }

    public OAuth2Service setApiSecret(String secret) {
        this.document.field(PROP_API_SECRET, (Object)secret);
        return this;
    }

    public IOAuth2Provider getProvider() {
        String alias = (String)this.document.field(PROP_PROVIDER);
        return OAuth2Provider.valueOf(alias);
    }

    public OAuth2Service setProvider(IOAuth2Provider provider) {
        this.document.field(PROP_PROVIDER, (Object)(provider != null ? provider.getName() : null));
        return this;
    }

    public String getCallback() {
        return (String)DBClosure.sudo(this::getCallback);
    }

    public String getCallback(ODatabaseDocument db) {
        return OrienteerUserModuleRepository.getModuleModel(db).map(OrienteerUsersModule.ModuleModel::getFullOAuth2Callback).orElse(null);
    }

    public boolean isActive() {
        return (Boolean)this.document.field(PROP_ACTIVE);
    }

    public OAuth2Service setActive(boolean active) {
        this.document.field(PROP_ACTIVE, (Object)active);
        return this;
    }
}

