/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.model;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import org.orienteer.users.model.OAuth2Service;

public class OAuth2ServiceContext
extends ODocumentWrapper {
    public static final String CLASS_NAME = "OAuth2ServiceContext";
    public static final String PROP_STATE = "state";
    public static final String PROP_SERVICE = "service";
    public static final String PROP_USED = "used";
    public static final String PROP_AUTHORIZATION_URL = "authorizationUrl";
    public static final String PROP_REGISTRATION = "registration";
    public static final String PROP_SOCIAL_NETWORK_LINK = "socialNetworkLink";

    public OAuth2ServiceContext() {
        this(CLASS_NAME);
    }

    public OAuth2ServiceContext(ORID iRID) {
        super(iRID);
    }

    public OAuth2ServiceContext(String iClassName) {
        super(iClassName);
    }

    public OAuth2ServiceContext(ODocument iDocument) {
        super(iDocument);
    }

    public OAuth2ServiceContext setState(String state) {
        this.document.field(PROP_STATE, (Object)state);
        return this;
    }

    public String getState() {
        return (String)this.document.field(PROP_STATE);
    }

    public OAuth2Service getService() {
        ODocument doc = this.getServiceAsDocument();
        return doc != null ? new OAuth2Service(doc) : null;
    }

    public ODocument getServiceAsDocument() {
        OIdentifiable identifiable = (OIdentifiable)this.document.field(PROP_SERVICE);
        return identifiable != null ? (ODocument)identifiable.getRecord() : null;
    }

    public boolean isUsed() {
        return (Boolean)this.document.field(PROP_USED);
    }

    public OAuth2ServiceContext setUsed(boolean used) {
        this.document.field(PROP_USED, (Object)used);
        return this;
    }

    public OAuth2ServiceContext setService(OAuth2Service service) {
        return this.setServiceAsDocument(service != null ? service.getDocument() : null);
    }

    public OAuth2ServiceContext setServiceAsDocument(ODocument service) {
        this.document.field(PROP_SERVICE, (Object)service);
        return this;
    }

    public String getAuthorizationUrl() {
        return (String)this.document.field(PROP_AUTHORIZATION_URL);
    }

    public OAuth2ServiceContext setAuthorizationUrl(String url) {
        this.document.field(PROP_AUTHORIZATION_URL, (Object)url);
        return this;
    }

    public boolean isRegistration() {
        return (Boolean)this.document.field(PROP_REGISTRATION);
    }

    public OAuth2ServiceContext setRegistration(boolean registration) {
        this.document.field(PROP_REGISTRATION, (Object)registration);
        return this;
    }

    public boolean isSocialNetworkLink() {
        Boolean socialNetworkLink = (Boolean)this.document.field(PROP_SOCIAL_NETWORK_LINK);
        return socialNetworkLink != null && socialNetworkLink != false;
    }

    public OAuth2ServiceContext setSocialNetworkLink(boolean socialNetworkLink) {
        this.document.field(PROP_SOCIAL_NETWORK_LINK, (Object)socialNetworkLink);
        return this;
    }
}

