/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.module;

import com.google.common.base.Strings;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibrary;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.orienteer.core.CustomAttribute;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.visualizer.IVisualizer;
import org.orienteer.core.method.MethodStorage;
import org.orienteer.core.method.OMethodsManager;
import org.orienteer.core.module.AbstractOrienteerModule;
import org.orienteer.core.util.OSchemaHelper;
import org.orienteer.users.component.visualizer.OAuth2ProviderVisualizer;
import org.orienteer.users.hook.OrienteerUserHook;
import org.orienteer.users.hook.OrienteerUserRoleHook;
import org.orienteer.users.resource.RegistrationResource;
import org.orienteer.users.resource.RestorePasswordResource;
import org.orienteer.users.util.OUsersCommonUtils;
import ru.ydn.wicket.wicketorientdb.security.OSecurityHelper;
import ru.ydn.wicket.wicketorientdb.security.OrientPermission;

public class OrienteerUsersModule
extends AbstractOrienteerModule {
    public static final String ORIENTEER_USER_ROLE = "orienteerUser";
    public static final String ORIENTEER_USER_PERSPECTIVE = "orienteerUserPerspective";
    public static final String READER_PERSPECTIVE = "readerPerspective";
    public static final String EVENT_RESTORE_PASSWORD_PREFIX = "removeUserRestoreId";
    public static final String FUN_REMOVE_RESTORE_ID = "removeRestoreId";
    public static final String PARAM_RESTORE_ID = "restoreId";
    public static final String PARAM_EVENT_NAME = "eventName";
    public static final String PARAM_TIMEOUT = "timeout";
    public static final String MODULE_NAME = "orienteer-users";
    public static final int VERSION = 14;
    public static final CustomAttribute REMOVE_CRON_RULE = CustomAttribute.create((String)"remove.cron", (OType)OType.STRING, (Object)"", (boolean)false, (boolean)false);
    public static final CustomAttribute REMOVE_SCHEDULE_START_TIMEOUT = CustomAttribute.create((String)"remove.timeout", (OType)OType.STRING, (Object)"0", (boolean)false, (boolean)false);
    public static final String MAIL_RESTORE = "restore";
    public static final String MAIL_REGISTRATION = "registration";
    public static final String MAIL_MACROS_LINK = "link";
    public static final String TAB_SOCIAL_NETWORKS = "social-networks";

    protected OrienteerUsersModule() {
        super(MODULE_NAME, 14, new String[]{"perspectives", "orienteer-mail"});
    }

    public ODocument onInstall(OrienteerWebApplication app, ODatabaseDocument db) {
        OSchemaHelper helper = OSchemaHelper.bind((ODatabaseDocument)db);
        this.createOAuth2Services(helper);
        this.createUserSocialNetwork(helper);
        OClass user = this.updateUserOClass(helper);
        this.updateDefaultOrienteerUsers(db);
        helper.oIndex(user.getProperty("id").getFullName(), OClass.INDEX_TYPE.UNIQUE, new String[]{"id"});
        OUsersCommonUtils.setRestricted(db, helper.oClass("OIdentity", new String[0]).getOClass());
        OUsersCommonUtils.setRestricted(db, helper.oClass("OPerspective", new String[0]).getOClass());
        ODocument perspective = this.createOrienteerUsersPerspective(db);
        ODocument readerPerspective = this.createReaderPerspective(db);
        ODocument reader = this.updateAndGetUserReader(db);
        this.updateReaderPermissions(db, reader, readerPerspective);
        this.updateOrienteerUserRoleDoc(db, perspective);
        this.createRemoveRestoreIdFunction(helper);
        this.configureModuleClass(helper);
        return this.createModuleDocument(db);
    }

    private ODocument createModuleDocument(ODatabaseDocument db) {
        List docs = db.query((OQuery)new OSQLSynchQuery("select from OrienteerUsers", 1), new Object[0]);
        if (docs != null && !docs.isEmpty()) {
            return null;
        }
        return new ODocument("OrienteerUsers");
    }

    private void configureModuleClass(OSchemaHelper helper) {
        helper.oClass("OrienteerUsers", new String[]{"OModule"}).oProperty("domain", OType.STRING, 40).notNull().defaultValue("http://localhost:8080").oProperty("oauth2", OType.BOOLEAN, 50).notNull().defaultValue("true").oProperty(MAIL_REGISTRATION, OType.BOOLEAN, 60).notNull().defaultValue("true").oProperty("registerUserOnOAuth2Login", OType.BOOLEAN, 70).notNull().defaultValue("false").oProperty("restorePassword", OType.BOOLEAN, 80).notNull().defaultValue("true").oProperty("oauth2Callback", OType.STRING, 90).notNull().defaultValue("/login");
    }

    private void createUserSocialNetwork(OSchemaHelper helper) {
        helper.oClass("OUserSocialNetwork", new String[]{"ORestricted"}).oProperty("service", OType.LINK, 0).linkedClass("OAuth2Service").oProperty("userId", OType.STRING, 10).oProperty("user", OType.LINK, 20);
    }

    private OClass updateUserOClass(OSchemaHelper helper) {
        helper.oClass("OUser", new String[0]).oProperty("id", OType.STRING).notNull().updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)true).oProperty(PARAM_RESTORE_ID, OType.STRING).updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)true).updateCustomAttribute(REMOVE_CRON_RULE, (Object)"0 0/1 * * * ?").updateCustomAttribute(REMOVE_SCHEDULE_START_TIMEOUT, (Object)"86400000").oProperty("restoreIdCreated", OType.DATETIME).updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)true).oProperty("email", OType.STRING).set(OProperty.ATTRIBUTES.COLLATE, (Object)"ci").oProperty("firstName", OType.STRING).oProperty("lastName", OType.STRING).oProperty("socialNetworks", OType.LINKLIST, 0).assignTab(TAB_SOCIAL_NETWORKS).assignVisualization("table");
        helper.setupRelationship("OUser", "socialNetworks", "OUserSocialNetwork", "user");
        return helper.getOClass();
    }

    private void updateOrienteerUserRoleDoc(ODatabaseDocument db, ODocument perspective) {
        OSecurity security = db.getMetadata().getSecurity();
        ORole role = security.getRole(ORIENTEER_USER_ROLE);
        if (role == null) {
            ORole reader = security.getRole("reader");
            role = security.createRole(ORIENTEER_USER_ROLE, reader, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        }
        role.grant(ORule.ResourceGeneric.CLASS, "OWidget", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "ODashboard", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "OPerspectiveItem", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "OPerspective", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "ORole", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.SCHEMA, null, OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLUSTER, "internal", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.RECORD_HOOK, "", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.DATABASE, null, OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.DATABASE, "systemclusters", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.DATABASE, "function", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.DATABASE, "command", OrientPermission.READ.getPermissionFlag());
        role.grant(OSecurityHelper.FEATURE_RESOURCE, "search", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "OUser", OrientPermission.combinedPermission((OrientPermission[])new OrientPermission[]{OrientPermission.READ, OrientPermission.UPDATE}));
        role.grant(ORule.ResourceGeneric.CLASS, "OUserSocialNetwork", 11);
        role.grant(ORule.ResourceGeneric.DATABASE, "cluster", OrientPermission.combinedPermission((OrientPermission[])new OrientPermission[]{OrientPermission.READ, OrientPermission.UPDATE}));
        role.getDocument().field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singletonList(role.getDocument()));
        role.getDocument().field("perspective", (Object)perspective);
        role.save();
        perspective.field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singletonList(role.getDocument()));
        perspective.save();
    }

    private void updateReaderPermissions(ODatabaseDocument db, ODocument reader, ODocument perspective) {
        ORole role = db.getMetadata().getSecurity().getRole("reader");
        role.grant(ORule.ResourceGeneric.CLASS, "OPerspectiveItem", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, "OPerspective", OrientPermission.READ.getPermissionFlag());
        role.grant(ORule.ResourceGeneric.CLASS, null, 0);
        role.grant(ORule.ResourceGeneric.CLASS, "ORole", OrientPermission.READ.getPermissionFlag());
        role.grant(OSecurityHelper.FEATURE_RESOURCE, "search", 0);
        role.grant(OSecurityHelper.FEATURE_RESOURCE, "schema", 0);
        role.getDocument().field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singletonList(reader));
        role.getDocument().field("perspective", (Object)perspective);
        role.save();
        perspective.field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singleton(role.getDocument()));
        perspective.save();
    }

    private ODocument createOrienteerUsersPerspective(ODatabaseDocument db) {
        ODocument perspective = OUsersCommonUtils.getOrCreatePerspective(db, ORIENTEER_USER_PERSPECTIVE);
        perspective.field("icon", (Object)FAIconType.user_o.name());
        perspective.field("homeUrl", (Object)"/browse/OUser");
        perspective.save();
        ODocument item1 = OUsersCommonUtils.getOrCreatePerspectiveItem(db, perspective, "perspective.menu.item.profile");
        item1.field("icon", (Object)FAIconType.user_o.name());
        item1.field("perspective", (Object)perspective);
        item1.field("url", (Object)"/browse/OUser");
        item1.save();
        perspective.save();
        return perspective;
    }

    private ODocument createReaderPerspective(ODatabaseDocument db) {
        ODocument perspective = OUsersCommonUtils.getOrCreatePerspective(db, READER_PERSPECTIVE);
        perspective.field("icon", (Object)FAIconType.database.name());
        perspective.field("homeUrl", (Object)"/browse/OUser");
        perspective.save();
        return perspective;
    }

    private ODocument updateAndGetUserReader(ODatabaseDocument db) {
        String sql = String.format("select from %s where name = ?", "OUser");
        List docs = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{"reader"});
        ODocument reader = (ODocument)docs.get(0);
        Set users = (Set)reader.field(ORestrictedOperation.ALLOW_READ.getFieldName(), Set.class);
        if (users == null || users.isEmpty()) {
            reader.field(ORestrictedOperation.ALLOW_READ.getFieldName(), Collections.singleton(reader));
        } else {
            users.add(reader);
            reader.field(ORestrictedOperation.ALLOW_READ.getFieldName(), (Object)users);
        }
        reader.save();
        return reader;
    }

    private void createRemoveRestoreIdFunction(OSchemaHelper helper) {
        OFunctionLibrary lib = helper.getDatabase().getMetadata().getFunctionLibrary();
        if (lib.getFunction(FUN_REMOVE_RESTORE_ID) != null) {
            lib.dropFunction(FUN_REMOVE_RESTORE_ID);
        }
        OFunction function = lib.createFunction(FUN_REMOVE_RESTORE_ID);
        function.setName(FUN_REMOVE_RESTORE_ID);
        function.setLanguage("javascript");
        function.setCode(this.createCodeForRemoveRestoreIdFunction());
        function.setParameters(this.createParamsForRemoveRestoreIdFunction());
        function.save();
    }

    private String createCodeForRemoveRestoreIdFunction() {
        return String.format("var res = db.command('UPDATE %s SET %s = null, %s = null WHERE %s = ? AND %s <= (sysdate() - ?)', %s, %s);\nif (res > 0) db.command('DELETE FROM OSchedule WHERE name = ?', %s);", "OUser", PARAM_RESTORE_ID, "restoreIdCreated", PARAM_RESTORE_ID, "restoreIdCreated", PARAM_RESTORE_ID, PARAM_TIMEOUT, PARAM_EVENT_NAME);
    }

    private List<String> createParamsForRemoveRestoreIdFunction() {
        LinkedList<String> params = new LinkedList<String>();
        params.add(PARAM_RESTORE_ID);
        params.add(PARAM_EVENT_NAME);
        params.add(PARAM_TIMEOUT);
        return params;
    }

    private void updateDefaultOrienteerUsers(ODatabaseDocument db) {
        OSecurity security = db.getMetadata().getSecurity();
        ODocument admin = security.getUser("admin").getDocument();
        admin.field("id", (Object)UUID.randomUUID().toString());
        admin.field("email", (Object)"admin@gmail.com");
        admin.save();
        ODocument reader = security.getUser("reader").getDocument();
        reader.field("id", (Object)UUID.randomUUID().toString());
        reader.field("email", (Object)"reader@gmail.com");
        reader.save();
        ODocument writer = security.getUser("writer").getDocument();
        writer.field("id", (Object)UUID.randomUUID().toString());
        writer.field("email", (Object)"writer@gmail.com");
        writer.save();
    }

    private void createOAuth2Services(OSchemaHelper helper) {
        helper.oClass("OAuth2Service", new String[0]).oProperty("apiKey", OType.STRING, 0).notNull().assignVisualization("password").oProperty("apiSecret", OType.STRING, 10).notNull().assignVisualization("password").oProperty("provider", OType.STRING, 30).notNull().markAsDocumentName().assignVisualization("oauth2-visualizer").updateCustomAttribute(CustomAttribute.DISPLAYABLE, (Object)"true").oIndex(OClass.INDEX_TYPE.UNIQUE).oProperty("active", OType.BOOLEAN, 40).notNull().defaultValue("true").updateCustomAttribute(CustomAttribute.DISPLAYABLE, (Object)"true");
        helper.oClass("OAuth2ServiceContext", new String[0]).oProperty("state", OType.STRING, 0).notNull().updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)"true").oProperty("service", OType.LINK, 10).linkedClass("OAuth2Service").notNull().updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)"true").oProperty("used", OType.BOOLEAN, 20).defaultValue("false").notNull().updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)"true").oProperty("authorizationUrl", OType.STRING, 30).notNull().updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)"true").oProperty(MAIL_REGISTRATION, OType.BOOLEAN, 40).notNull().defaultValue("false").updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)"true").oProperty("socialNetworkLink", OType.BOOLEAN, 50).notNull().defaultValue("false").updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)"true");
    }

    public void onUpdate(OrienteerWebApplication app, ODatabaseDocument db, int oldVersion, int newVersion) {
        this.onInstall(app, db);
    }

    public void onInitialize(OrienteerWebApplication app, ODatabaseDocument db) {
        List hooks = app.getOrientDbSettings().getORecordHooks();
        hooks.add(OrienteerUserHook.class);
        hooks.add(OrienteerUserRoleHook.class);
        RegistrationResource.mount(app);
        RestorePasswordResource.mount(app);
        app.mountPackage("org.orienteer.users.web");
        app.registerWidgets("org.orienteer.users.widget");
        app.getUIVisualizersRegistry().registerUIComponentFactory((IVisualizer)new OAuth2ProviderVisualizer());
        this.initMethods();
        OScheduler scheduler = db.getMetadata().getScheduler();
        Collection events = scheduler.getEvents().values();
        for (OScheduledEvent event : events) {
            scheduler.updateEvent(event);
        }
    }

    public void onDestroy(OrienteerWebApplication app, ODatabaseDocument db) {
        List hooks = app.getOrientDbSettings().getORecordHooks();
        hooks.remove(OrienteerUserHook.class);
        hooks.remove(OrienteerUserRoleHook.class);
        RegistrationResource.unmount(app);
        RestorePasswordResource.unmount(app);
        app.unmountPackage("org.orienteer.users.web");
        app.unregisterWidgets("org.orienteer.users.widget");
        app.getUIVisualizersRegistry().unregisterUIComponentFactory(Collections.singletonList(OType.STRING), "oauth2-visualizer");
    }

    private void initMethods() {
        try {
            OMethodsManager manager = OMethodsManager.get();
            Field methodStorageField = manager.getClass().getDeclaredField("methodStorage");
            methodStorageField.setAccessible(true);
            MethodStorage storage = (MethodStorage)methodStorageField.get(manager);
            storage.addPath("org.orienteer.users");
            manager.reload();
            methodStorageField.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ModuleModel
    extends ODocumentWrapper {
        public static final String CLASS_NAME = "OrienteerUsers";
        public static final String PROP_DOMAIN = "domain";
        public static final String PROP_OAUTH2 = "oauth2";
        public static final String PROP_REGISTRATION = "registration";
        public static final String PROP_REGISTER_USER_ON_OAUTH2_LOGIN = "registerUserOnOAuth2Login";
        public static final String PROP_RESTORE_PASSWORD = "restorePassword";
        public static final String PROP_OAUTH2_CALLBACK = "oauth2Callback";

        public ModuleModel() {
            this(CLASS_NAME);
        }

        public ModuleModel(String iClassName) {
            super(iClassName);
        }

        public ModuleModel(ODocument iDocument) {
            super(iDocument);
        }

        public String getDomain() {
            return (String)this.document.field(PROP_DOMAIN);
        }

        public ModuleModel setDomain(String domain) {
            this.document.field(PROP_DOMAIN, (Object)domain);
            return this;
        }

        public boolean isOAuth2() {
            return (Boolean)this.document.field(PROP_OAUTH2);
        }

        public ModuleModel setOAuth2(boolean oauth2) {
            this.document.field(PROP_OAUTH2, (Object)oauth2);
            return this;
        }

        public String getOAuth2Callback() {
            return (String)this.document.field(PROP_OAUTH2_CALLBACK);
        }

        public ModuleModel setOAuth2Callback(String callback) {
            this.document.field(PROP_OAUTH2_CALLBACK, (Object)callback);
            return this;
        }

        public boolean isRegistration() {
            return (Boolean)this.document.field("registration");
        }

        public ModuleModel setRegistration(boolean registration) {
            this.document.field("registration", (Object)registration);
            return this;
        }

        public boolean isRestorePassword() {
            return (Boolean)this.document.field(PROP_RESTORE_PASSWORD);
        }

        public ModuleModel setRestorePassword(boolean restorePassword) {
            this.document.field(PROP_RESTORE_PASSWORD, (Object)restorePassword);
            return this;
        }

        public boolean isRegisterUserOnOAuth2Login() {
            return (Boolean)this.document.field(PROP_REGISTER_USER_ON_OAUTH2_LOGIN);
        }

        public ModuleModel setRegisterUserOnOAuth2Login(boolean register) {
            this.document.field(PROP_REGISTER_USER_ON_OAUTH2_LOGIN, (Object)register);
            return this;
        }

        public String getFullOAuth2Callback() {
            String domain = this.getDomain();
            String callback = this.getOAuth2Callback();
            if (Strings.isNullOrEmpty((String)domain)) {
                return null;
            }
            if (!domain.endsWith("/")) {
                domain = domain + "/";
            }
            if (Strings.isNullOrEmpty((String)callback)) {
                return domain;
            }
            if (callback.startsWith("/")) {
                callback = callback.substring(1);
            }
            return domain + callback;
        }
    }
}

