/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.repository;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public final class DatabaseHelper {
    private static final int ATTEMPTS = 10;
    private static final String SELECT_TEMPLATE = "select from %s where %s = ?";
    private static final String DELETE_TEMPLATE = "delete from %s where %s = ?";
    private static final String DELETE_RECORDS_TEMPLATE = "delete from ?";

    private DatabaseHelper() {
    }

    public static void save(ODocumentWrapper wrapper) {
        DBClosure.sudoConsumer(db -> DatabaseHelper.save(db, wrapper));
    }

    public static void save(ODatabaseDocument db, ODocumentWrapper wrapper) {
        DatabaseHelper.save(db, wrapper.getDocument());
    }

    public static void save(ODocumentWrapper ... wrappers) {
        DBClosure.sudoConsumer(db -> DatabaseHelper.save(db, wrappers));
    }

    public static void save(ODatabaseDocument db, ODocumentWrapper ... wrappers) {
        List docs = Arrays.stream(wrappers).map(ODocumentWrapper::getDocument).collect(Collectors.toCollection(LinkedList::new));
        DatabaseHelper.save(db, docs);
    }

    public static void save(ODocument doc) {
        DBClosure.sudoConsumer(db -> DatabaseHelper.save(db, doc));
    }

    public static void save(ODatabaseDocument db, ODocument doc) {
        DatabaseHelper.update(db, database -> doc.save());
    }

    public static void save(ODatabaseDocument db, ODocument ... docs) {
        DatabaseHelper.save(db, Arrays.asList(docs));
    }

    public static void save(ODatabaseDocument db, List<ODocument> docs) {
        DatabaseHelper.update(db, database -> {
            docs.forEach(ODocument::save);
            return null;
        });
    }

    public static void delete(ODocumentWrapper wrapper) {
        DBClosure.sudoConsumer(db -> DatabaseHelper.delete(db, wrapper));
    }

    public static void delete(ODocumentWrapper ... wrappers) {
        List docs = Arrays.stream(wrappers).map(ODocumentWrapper::getDocument).collect(Collectors.toCollection(LinkedList::new));
        DBClosure.sudoConsumer(db -> DatabaseHelper.delete(db, docs));
    }

    public static void delete(ODocument ... docs) {
        DBClosure.sudoConsumer(db -> DatabaseHelper.delete(db, Arrays.asList(docs)));
    }

    public static void delete(List<ODocument> docs) {
        DBClosure.sudoConsumer(db -> DatabaseHelper.delete(db, docs));
    }

    public static void delete(ODatabaseDocument db, List<ODocument> docs) {
        db.command((OCommandRequest)new OCommandSQL(DELETE_RECORDS_TEMPLATE)).execute(new Object[]{docs});
    }

    public static void delete(ODatabaseDocument db, ODocumentWrapper wrapper) {
        DatabaseHelper.delete(db, wrapper.getDocument());
    }

    public static void delete(ODocument doc) {
        DBClosure.sudoConsumer(db -> DatabaseHelper.delete(db, doc));
    }

    public static void delete(ODatabaseDocument db, ODocument doc) {
        DatabaseHelper.update(db, database -> database.delete((Object)doc));
    }

    static <T> T update(ODatabaseDocument db, Function<ODatabaseDocument, T> updateFunc) {
        for (int i = 1; i <= 10; ++i) {
            try {
                T result = updateFunc.apply(db);
                db.commit();
                return result;
            }
            catch (Exception ex) {
                if (i != 10) continue;
                db.rollback();
                throw new IllegalStateException(ex);
            }
        }
        throw new IllegalStateException("Something wrong happened...");
    }

    static <T> T update(Function<ODatabaseDocument, T> updateFunc) {
        return (T)DBClosure.sudo(db -> DatabaseHelper.update(db, updateFunc));
    }

    static String selectFromBy(String className, String fieldName) {
        return String.format(SELECT_TEMPLATE, className, fieldName);
    }

    static String deleteFromBy(String className, String fieldName) {
        return String.format(DELETE_TEMPLATE, className, fieldName);
    }
}

