/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.repository;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Optional;
import org.orienteer.core.util.CommonUtils;
import org.orienteer.users.model.OAuth2Provider;
import org.orienteer.users.model.OAuth2Service;
import org.orienteer.users.model.OAuth2ServiceContext;
import org.orienteer.users.repository.DatabaseHelper;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public final class OAuth2Repository {
    private OAuth2Repository() {
    }

    public static List<OAuth2Service> getOAuth2Services() {
        return (List)DBClosure.sudo(OAuth2Repository::getOAuth2Services);
    }

    public static List<OAuth2Service> getOAuth2Services(boolean active) {
        return (List)DBClosure.sudo(db -> OAuth2Repository.getOAuth2Services(db, active));
    }

    public static List<OAuth2Service> getOAuth2Services(ODatabaseDocument db) {
        String sql = String.format("select from %s", "OAuth2Service");
        List services = db.query((OQuery)new OSQLSynchQuery(sql), new Object[0]);
        return CommonUtils.mapIdentifiables((List)services, OAuth2Service::new);
    }

    public static List<OAuth2Service> getOAuth2Services(ODatabaseDocument db, boolean active) {
        String sql = DatabaseHelper.selectFromBy("OAuth2Service", "active");
        List services = db.query((OQuery)new OSQLSynchQuery(sql), new Object[]{active});
        return CommonUtils.mapIdentifiables((List)services, OAuth2Service::new);
    }

    public static Optional<OAuth2Service> getOAuth2ServiceByProvider(ODatabaseDocument db, OAuth2Provider provider, boolean active) {
        return OAuth2Repository.getOAuth2ServiceByProvider(db, provider.getName(), active);
    }

    public static Optional<OAuth2Service> getOAuth2ServiceByProvider(ODatabaseDocument db, String provider, boolean active) {
        String sql = String.format("select from %s where %s = ? and %s = ?", "OAuth2Service", "provider", "active");
        List identifiables = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{provider, active});
        return CommonUtils.getFromIdentifiables((List)identifiables, OAuth2Service::new);
    }

    public static Optional<OAuth2ServiceContext> getServiceContextByState(String state) {
        return (Optional)DBClosure.sudo(db -> OAuth2Repository.getServiceContextByState(db, state));
    }

    public static Optional<OAuth2ServiceContext> getServiceContextByState(ODatabaseDocument db, String state) {
        String sql = String.format("select from %s where %s = ?", "OAuth2ServiceContext", "state");
        List identifiables = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{state});
        return CommonUtils.getFromIdentifiables((List)identifiables, OAuth2ServiceContext::new);
    }
}

