/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.repository;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Optional;
import org.orienteer.core.util.CommonUtils;
import org.orienteer.users.model.IOAuth2Provider;
import org.orienteer.users.model.OUserSocialNetwork;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public final class OUserSocialNetworkRepository {
    private OUserSocialNetworkRepository() {
    }

    public static Optional<OUserSocialNetwork> getSocialNetworkByUserId(IOAuth2Provider provider, String userId) {
        return OUserSocialNetworkRepository.getSocialNetworkByUserId(provider.getName(), userId);
    }

    public static Optional<OUserSocialNetwork> getSocialNetworkByUserId(String providerAlias, String userId) {
        return (Optional)DBClosure.sudo(db -> OUserSocialNetworkRepository.getSocialNetworkByUserId(db, providerAlias, userId));
    }

    public static Optional<OUserSocialNetwork> getSocialNetworkByUserId(ODatabaseDocument db, IOAuth2Provider provider, String userId) {
        return OUserSocialNetworkRepository.getSocialNetworkByUserId(db, provider.getName(), userId);
    }

    public static Optional<OUserSocialNetwork> getSocialNetworkByUserId(ODatabaseDocument db, String providerAlias, String userId) {
        String sql = String.format("select from %s where %s = ? and %s = ?", "OUserSocialNetwork", "service", "userId");
        List identifiables = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{providerAlias, userId});
        return CommonUtils.getFromIdentifiables((List)identifiables, OUserSocialNetwork::new);
    }
}

