/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.repository;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Optional;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.module.PerspectivesModule;
import org.orienteer.core.util.CommonUtils;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.repository.DatabaseHelper;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public final class OrienteerUserRepository {
    private OrienteerUserRepository() {
    }

    public static Optional<ODocument> getDefaultOrienteerUserPerspective() {
        return (Optional)DBClosure.sudo(db -> {
            PerspectivesModule perspectivesModule = (PerspectivesModule)OrienteerWebApplication.lookupApplication().getServiceInstance(PerspectivesModule.class);
            return perspectivesModule.getPerspectiveByAliasAsDocument(db, "orienteerUserPerspective");
        });
    }

    public static Optional<ORole> getRoleByName(String name) {
        return (Optional)DBClosure.sudo(db -> Optional.ofNullable(db.getMetadata().getSecurity().getRole(name)));
    }

    public static Optional<OrienteerUser> getUserByRestoreId(String restoreId) {
        return OrienteerUserRepository.getUserBy("restoreId", restoreId);
    }

    public static Optional<OrienteerUser> getUserById(String id) {
        return OrienteerUserRepository.getUserBy("id", id);
    }

    public static Optional<OrienteerUser> getUserByEmail(String email) {
        return OrienteerUserRepository.getUserBy("email", email);
    }

    public static Optional<OrienteerUser> getUserByEmail(ODatabaseDocument db, String email) {
        return OrienteerUserRepository.getUserBy(db, "email", email);
    }

    public static Optional<OrienteerUser> getUserByName(ODatabaseDocument db, String name) {
        return OrienteerUserRepository.getUserBy(db, "name", name);
    }

    public static boolean isUserExistsWithRestoreId(String restoreId) {
        return OrienteerUserRepository.isUserExistsBy("restoreId", restoreId);
    }

    public static boolean isUserExistsWithEmail(String email) {
        return OrienteerUserRepository.isUserExistsBy("email", email);
    }

    public static boolean isUserExistsWithId(String id) {
        return OrienteerUserRepository.isUserExistsBy("id", id);
    }

    private static boolean isUserExistsBy(String field, String value) {
        return (Boolean)DBClosure.sudo(db -> {
            String sql = String.format("select count(*) from %s where %s = ?", "OUser", field);
            List documents = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{value});
            return CommonUtils.getDocument((List)documents).map(d -> (Long)d.field("count") == 1L).orElse(false);
        });
    }

    public static Optional<OrienteerUser> getUserBy(String field, String value) {
        return (Optional)DBClosure.sudo(db -> OrienteerUserRepository.getUserBy(db, field, value));
    }

    public static Optional<OrienteerUser> getUserBy(ODatabaseDocument db, String field, String value) {
        String sql = DatabaseHelper.selectFromBy("OUser", field);
        List identifiables = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{value});
        return CommonUtils.getFromIdentifiables((List)identifiables, OrienteerUser::new);
    }
}

