/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.resource;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.SharedResourceReference;
import org.apache.wicket.util.time.Time;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.users.repository.OrienteerUserModuleRepository;
import org.orienteer.users.repository.OrienteerUserRepository;
import org.orienteer.users.service.IOrienteerUsersService;

public class RestorePasswordResource
extends AbstractResource {
    public static final String MOUNT_PATH = "/restore/${id}/";
    public static final String RES_KEY = RestorePasswordResource.class.getName();
    public static final String PARAMETER_ID = "id";
    @Inject
    private IOrienteerUsersService service;

    public static String getLinkForUser(OSecurityUser user) {
        return RestorePasswordResource.getLinkForUser(user.getDocument());
    }

    public static String getLinkForUser(ODocument doc) {
        String id = (String)doc.field("restoreId");
        PageParameters params = new PageParameters();
        params.add(PARAMETER_ID, (Object)id);
        CharSequence url = RequestCycle.get().urlFor((ResourceReference)new SharedResourceReference(RES_KEY), params);
        return RequestCycle.get().getUrlRenderer().renderFullUrl(Url.parse((CharSequence)url));
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setLastModified(Time.now());
        if (response.dataNeedsToBeWritten(attributes)) {
            response.setWriteCallback(this.createWriteCallback());
            response.setStatusCode(Integer.valueOf(200));
        }
        return response;
    }

    private AbstractResource.WriteCallback createWriteCallback() {
        return new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                if (OrienteerUserModuleRepository.isRestorePassword()) {
                    String id = attributes.getParameters().get(RestorePasswordResource.PARAMETER_ID).toString();
                    PageParameters params = new PageParameters();
                    if (!Strings.isNullOrEmpty((String)id) && OrienteerUserRepository.isUserExistsWithRestoreId(id)) {
                        params.add(RES_KEY, (Object)id);
                        RequestCycle.get().setResponsePage(RestorePasswordResource.this.service.getRestorePasswordPage(), params);
                    } else {
                        RequestCycle.get().setResponsePage(OrienteerWebApplication.lookupApplication().getHomePage());
                    }
                } else {
                    RequestCycle.get().setResponsePage(OrienteerWebApplication.lookupApplication().getHomePage());
                }
            }
        };
    }

    public static void mount(OrienteerWebApplication app) {
        app.getSharedResources().add(RES_KEY, (IResource)app.getServiceInstance(RestorePasswordResource.class));
        app.mountResource(MOUNT_PATH, (ResourceReference)new SharedResourceReference(RES_KEY));
    }

    public static void unmount(OrienteerWebApplication app) {
        app.getSharedResources().remove(app.getSharedResources().get(RES_KEY).getKey());
        app.unmount(MOUNT_PATH);
    }
}

