/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.service;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.schedule.OScheduledEventBuilder;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.wicket.markup.html.WebPage;
import org.orienteer.core.util.CommonUtils;
import org.orienteer.mail.model.OPreparedMail;
import org.orienteer.mail.service.IOMailService;
import org.orienteer.mail.util.OMailUtils;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.module.OrienteerUsersModule;
import org.orienteer.users.repository.OrienteerUserModuleRepository;
import org.orienteer.users.resource.RegistrationResource;
import org.orienteer.users.resource.RestorePasswordResource;
import org.orienteer.users.service.IOrienteerUsersService;
import org.orienteer.users.web.DefaultRegistrationPage;
import org.orienteer.users.web.DefaultRestorePasswordPage;
import org.orienteer.users.web.OUsersLoginPage;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

@Singleton
public class OrienteerUsersService
implements IOrienteerUsersService {
    @Inject
    private IOMailService mailService;

    @Override
    public void restoreUserPassword(OrienteerUser user) {
        if (OrienteerUserModuleRepository.isRestorePassword()) {
            this.clearRestoring(user);
            DBClosure.sudoConsumer(db -> {
                user.setRestoreId(UUID.randomUUID().toString()).setRestoreIdCreated(Instant.now()).save();
                String name = "removeUserRestoreId" + user.getRestoreId();
                OScheduler scheduler = db.getMetadata().getScheduler();
                scheduler.scheduleEvent(this.createRestorePasswordSchedulerEvent((ODatabaseDocument)db, user, name));
            });
            this.notifyUserAboutRestorePassword(user);
        }
    }

    @Override
    public void clearRestoring(OrienteerUser user) {
        if (user.getRestoreId() != null) {
            DBClosure.sudoConsumer(db -> {
                String eventName = "removeUserRestoreId" + user.getRestoreId();
                OScheduler scheduler = db.getMetadata().getScheduler();
                if (scheduler.getEvent(eventName) != null) {
                    scheduler.removeEvent(eventName);
                }
                user.setRestoreId(null);
                user.setRestoreIdCreatedAsDate(null);
                user.save();
            });
        }
    }

    @Override
    public void notifyUserAboutRegistration(OrienteerUser user) {
        if (OrienteerUserModuleRepository.isRegistrationActive()) {
            OMailUtils.getOMailByName((String)"registration").ifPresent(mail -> {
                OPreparedMail preparedMail = new OPreparedMail(mail, this.createRegistrationMailMacros(user));
                this.adjustRegistrationPreparedMail(preparedMail, user);
                DBClosure.sudoSave((ODocumentWrapper[])new ODocumentWrapper[]{preparedMail});
                this.mailService.sendMailAsync(preparedMail);
            });
        }
    }

    @Override
    public OrienteerUser createUser() {
        return new OrienteerUser("OUser");
    }

    @Override
    public Class<? extends WebPage> getRestorePasswordPage() {
        return DefaultRestorePasswordPage.class;
    }

    @Override
    public Class<? extends WebPage> getRegistrationPage() {
        return DefaultRegistrationPage.class;
    }

    @Override
    public Class<? extends WebPage> getLoginPage() {
        return OUsersLoginPage.class;
    }

    protected void notifyUserAboutRestorePassword(OrienteerUser user) {
        OMailUtils.getOMailByName((String)"restore").ifPresent(mail -> {
            OPreparedMail preparedMail = new OPreparedMail(mail, this.createRestoreMailMacros(user));
            this.adjustRestorePreparedMail(preparedMail, user);
            DBClosure.sudoSave((ODocumentWrapper[])new ODocumentWrapper[]{preparedMail});
            this.mailService.sendMailAsync(preparedMail);
        });
    }

    protected Map<String, Object> createRestoreMailMacros(OrienteerUser user) {
        return CommonUtils.toMap((Object[])new Object[]{"link", RestorePasswordResource.getLinkForUser((OSecurityUser)user)});
    }

    protected Map<String, Object> createRegistrationMailMacros(OrienteerUser user) {
        return CommonUtils.toMap((Object[])new Object[]{"link", RegistrationResource.createRegistrationLink(user)});
    }

    protected void adjustRestorePreparedMail(OPreparedMail preparedMail, OrienteerUser user) {
        preparedMail.addRecipient(user.getEmail());
    }

    protected void adjustRegistrationPreparedMail(OPreparedMail preparedMail, OrienteerUser user) {
        preparedMail.addRecipient(user.getEmail());
    }

    private OScheduledEvent createRestorePasswordSchedulerEvent(ODatabaseDocument db, OrienteerUser user, String eventName) {
        OProperty property = user.getDocument().getSchemaClass().getProperty("restoreId");
        OFunction fun = db.getMetadata().getFunctionLibrary().getFunction("removeRestoreId");
        long timeout = Long.parseLong((String)OrienteerUsersModule.REMOVE_SCHEDULE_START_TIMEOUT.getValue(property));
        return new OScheduledEventBuilder().setName(eventName).setFunction(fun).setArguments(this.createFunArguments(user, timeout, eventName)).setRule((String)OrienteerUsersModule.REMOVE_CRON_RULE.getValue(property)).setStartTime(new Date(System.currentTimeMillis() + timeout)).build();
    }

    private Map<Object, Object> createFunArguments(OrienteerUser user, long timeout, String eventName) {
        return CommonUtils.toMap((Object[])new Object[]{"restoreId", user.getRestoreId(), "timeout", timeout, "eventName", eventName});
    }
}

