/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.util;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.users.model.IOAuth2Provider;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;

public class OAuth2ProviderChoiceProvider
extends ChoiceProvider<String> {
    private final List<IOAuth2Provider> providers;

    public OAuth2ProviderChoiceProvider(List<IOAuth2Provider> providers) {
        this.providers = providers;
    }

    public String getDisplayValue(String name) {
        return this.providers.stream().filter(p -> Objects.equals(p.getName(), name)).map(this::createLabelModel).map(IModel::getObject).findFirst().orElseThrow(() -> new IllegalStateException("Can't find provider for name: " + name));
    }

    public String getIdValue(String label) {
        return label;
    }

    public void query(String term, int page, Response<String> response) {
        this.providers.stream().map(p -> {
            if (Strings.isNullOrEmpty((String)term)) {
                return p.getName();
            }
            String name = p.getName().toLowerCase();
            String label = (String)this.createLabelModel((IOAuth2Provider)p).getObject();
            label = label.toLowerCase();
            if (name.contains(term.toLowerCase()) || label.contains(term.toLowerCase())) {
                return p.getName();
            }
            return null;
        }).filter(Objects::nonNull).forEach(arg_0 -> response.add(arg_0));
    }

    public Collection<String> toChoices(Collection<String> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.providers.stream().filter(p -> ids.contains(p.getName())).map(IOAuth2Provider::getName).collect(Collectors.toCollection(LinkedList::new));
    }

    protected IModel<String> createLabelModel(IOAuth2Provider provider) {
        return new ResourceModel(provider.getLabel());
    }
}

