/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.util;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.orienteer.core.CustomAttribute;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.module.PerspectivesModule;
import org.orienteer.users.model.IOAuth2Provider;
import org.orienteer.users.model.OAuth2Provider;
import org.orienteer.users.model.OAuth2Service;
import org.orienteer.users.model.OUserSocialNetwork;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.repository.OAuth2Repository;

public final class OUsersCommonUtils {
    private OUsersCommonUtils() {
    }

    public static List<IOAuth2Provider> getOAuth2Providers() {
        OrienteerWebApplication app = OrienteerWebApplication.lookupApplication();
        if (app == null) {
            return Collections.emptyList();
        }
        Named named = Names.named((String)"orienteer.oauth2.providers");
        Key key = Key.get((TypeLiteral)new TypeLiteral<List<IOAuth2Provider>>(){}, (Annotation)named);
        return (List)app.getInjector().getInstance(key);
    }

    public static void setRestricted(ODatabaseDocument db, OClass oClass) {
        OClass restricted = db.getMetadata().getSchema().getClass("ORestricted");
        if (!oClass.isSubClassOf(restricted)) {
            oClass.addSuperClass(restricted);
            Collection properties = restricted.properties();
            oClass.properties().stream().filter(p -> !properties.contains(p)).filter(p -> (Boolean)CustomAttribute.HIDDEN.getValue(p) == false).forEach(p -> CustomAttribute.DISPLAYABLE.setValue(p, (Object)true));
        }
    }

    public static void createWidgetIfNotExists(ODatabaseDocument db, String typeId, String className, String domain, String tab) {
        ODocument dashboard = OUsersCommonUtils.getOrCreateDashboard(db, className, domain, tab);
        if (!OUsersCommonUtils.isWidgetExists(dashboard, typeId)) {
            ODocument doc = new ODocument("OWidget");
            doc.field("typeId", (Object)typeId);
            doc.field("dashboard", (Object)dashboard);
            doc.save();
        }
    }

    public static ODocument getOrCreateDashboard(ODatabaseDocument db, String className, String domain, String tab) {
        ODocument doc;
        String sql = String.format("select from %s where %s = ?", "ODashboard", "class");
        List docs = db.query((OQuery)new OSQLSynchQuery(sql, 1), new Object[]{className});
        if (docs == null || docs.isEmpty()) {
            doc = new ODocument("ODashboard");
            doc.field("domain", (Object)domain);
            doc.field("tab", (Object)tab);
            doc.field("class", (Object)className);
            doc.save();
        } else {
            doc = (ODocument)docs.get(0);
        }
        return doc;
    }

    public static ODocument getOrCreatePerspective(ODatabaseDocument db, String key) {
        return OUsersCommonUtils.getOrCreatePerspective(db, key, OUsersCommonUtils.createDefaultLanguageTags());
    }

    public static ODocument getOrCreatePerspective(ODatabaseDocument db, String key, List<String> tags) {
        OrienteerWebApplication app = OrienteerWebApplication.get();
        Map<String, String> localizedStrings = OUsersCommonUtils.getLocalizedStrings(app, key, tags);
        PerspectivesModule perspectivesModule = (PerspectivesModule)app.getServiceInstance(PerspectivesModule.class);
        return perspectivesModule.getPerspectiveByAliasAsDocument(db, key).orElseGet(() -> {
            ODocument newDoc = new ODocument("OPerspective");
            newDoc.field("name", (Object)localizedStrings);
            newDoc.field("alias", (Object)key);
            return newDoc;
        });
    }

    public static ODocument getOrCreatePerspectiveItem(ODatabaseDocument db, ODocument perspective, String key) {
        return OUsersCommonUtils.getOrCreatePerspectiveItem(db, perspective, key, OUsersCommonUtils.createDefaultLanguageTags());
    }

    public static ODocument getOrCreatePerspectiveItem(ODatabaseDocument db, ODocument perspective, String key, List<String> tags) {
        Map<String, String> localizedStrings = OUsersCommonUtils.getLocalizedStrings(OrienteerWebApplication.get(), key, tags);
        PerspectivesModule perspectivesModule = (PerspectivesModule)OrienteerWebApplication.lookupApplication().getServiceInstance(PerspectivesModule.class);
        return perspectivesModule.getPerspectiveItemByAliasAsDocument(db, key).orElseGet(() -> {
            ODocument doc = new ODocument("OPerspectiveItem");
            doc.field("name", (Object)localizedStrings);
            doc.field("alias", (Object)key);
            doc.field("perspective", (Object)perspective);
            return doc;
        });
    }

    public static boolean isWidgetExists(ODocument dashboard, String typeId) {
        List widgets = (List)dashboard.field("widgets", List.class);
        return widgets != null && !widgets.isEmpty() && widgets.stream().anyMatch(widget -> typeId.equals(((ODocument)widget.getRecord()).field("typeId")));
    }

    private static Map<String, String> getLocalizedStrings(OrienteerWebApplication app, String key, List<String> tags) {
        HashedMap localized = new HashedMap(3);
        for (String tag : tags) {
            localized.put(tag, OUsersCommonUtils.getString(app, key, Locale.forLanguageTag(tag)));
        }
        return localized;
    }

    public static String getString(OrienteerWebApplication app, String key, Locale locale) {
        return app.getResourceSettings().getLocalizer().getString(key, null, null, locale, null, "");
    }

    public static List<String> createDefaultLanguageTags() {
        return Arrays.asList("en", "ru", "uk");
    }

    public static void createOUserSocialNetworkIfNotExists(ODatabaseDocument db, OAuth2Provider provider, String userId, OrienteerUser user) {
        if (!OUsersCommonUtils.isProviderContainsInUserSocialNetworks(provider, user)) {
            OAuth2Repository.getOAuth2ServiceByProvider(db, provider, true).ifPresent(service -> {
                OUserSocialNetwork network = new OUserSocialNetwork();
                network.setService((OAuth2Service)((Object)service));
                network.setUser(user);
                network.setUserId(userId);
                network.save();
            });
        }
    }

    private static boolean isProviderContainsInUserSocialNetworks(OAuth2Provider provider, OrienteerUser user) {
        return user.getSocialNetworks().stream().map(OUserSocialNetwork::getService).map(OAuth2Service::getProvider).anyMatch(sp -> sp.equals(provider));
    }
}

