/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.web;

import com.google.common.base.Strings;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.flow.RedirectToUrlException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.orienteer.core.MountPath;
import org.orienteer.core.web.BasePage;
import org.orienteer.users.component.DefaultRestorePasswordPanel;
import org.orienteer.users.model.OrienteerUser;
import org.orienteer.users.repository.OrienteerUserRepository;
import ru.ydn.wicket.wicketorientdb.model.ODocumentWrapperModel;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

@MountPath(value="/restore")
public class DefaultRestorePasswordPage
extends BasePage<OrienteerUser> {
    private WebMarkupContainer container;

    public DefaultRestorePasswordPage() {
        throw new RedirectToUrlException("/home");
    }

    public DefaultRestorePasswordPage(PageParameters params) {
        super(params);
    }

    protected IModel<OrienteerUser> resolveByPageParameters(PageParameters params) {
        String id = params.get("id").toOptionalString();
        if (Strings.isNullOrEmpty((String)id)) {
            throw new RedirectToUrlException("/home");
        }
        return (IModel)OrienteerUserRepository.getUserByRestoreId(id).map(ODocumentWrapperModel::new).orElseThrow(() -> new RedirectToUrlException("/home"));
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.container = this.createContainer("container");
        componentArray[0] = this.container;
        this.add(componentArray);
        this.add(new Component[]{new Label("restoreTitle", this.getRestoreTitle())});
    }

    private WebMarkupContainer createContainer(String id) {
        return new WebMarkupContainer(id){

            protected void onInitialize() {
                super.onInitialize();
                this.add(new Component[]{DefaultRestorePasswordPage.this.createRestorePasswordPanel("restorePanel")});
                this.add(new Component[]{DefaultRestorePasswordPage.this.createRestoreSuccessMessage("restoreSuccessMessage")});
                this.setOutputMarkupPlaceholderTag(true);
            }
        };
    }

    protected GenericPanel<OrienteerUser> createRestorePasswordPanel(String id) {
        return new DefaultRestorePasswordPanel(id, this.getModel()){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(DBClosure.sudo(db -> (OrienteerUser)((Object)((Object)this.getModelObject()))) != null);
            }

            @Override
            protected void onRestore(AjaxRequestTarget target, IModel<OrienteerUser> model) {
                model.setObject(null);
                target.add(new Component[]{DefaultRestorePasswordPage.this.container});
            }
        };
    }

    protected WebMarkupContainer createRestoreSuccessMessage(String id) {
        return new WebMarkupContainer(id){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(DBClosure.sudo(db -> (OrienteerUser)((Object)((Object)DefaultRestorePasswordPage.this.getModelObject()))) == null);
            }

            protected void onInitialize() {
                super.onInitialize();
                this.add(new Component[]{new Link<Void>("loginPage"){

                    public void onClick() {
                        throw new RedirectToUrlException("/login");
                    }
                }});
                this.setOutputMarkupPlaceholderTag(true);
            }
        };
    }

    protected IModel<String> getRestoreTitle() {
        return new ResourceModel("page.restore.title");
    }

    public IModel<String> getTitleModel() {
        return new ResourceModel("page.restore.page.title");
    }

    protected String getBodyAppSubClasses() {
        return "flex-row align-items-center footer-fixed";
    }
}

