/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.users.web;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.orienteer.core.MountPath;
import org.orienteer.core.component.LoginButtonsPanel;
import org.orienteer.core.component.LoginPanel;
import org.orienteer.core.web.LoginPage;
import org.orienteer.users.component.OUsersLoginButtonsPanel;
import org.orienteer.users.component.OUsersLoginFooterPanel;
import org.orienteer.users.component.OUsersLoginPanel;
import org.orienteer.users.component.RestorePasswordPanel;
import org.orienteer.users.component.event.RestorePasswordEventPayload;
import org.orienteer.users.model.OAuth2Service;
import org.orienteer.users.model.OAuth2ServiceContext;
import org.orienteer.users.repository.OAuth2Repository;
import org.orienteer.users.repository.OrienteerUserModuleRepository;
import org.orienteer.users.service.IOAuth2Service;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

@MountPath(value="/login")
public class OUsersLoginPage
extends LoginPage {
    @Inject
    private IOAuth2Service authService;
    private final IModel<Boolean> restoreModel;
    private boolean closeWindow;

    public OUsersLoginPage() {
        this((IModel<Boolean>)Model.of((Serializable)Boolean.valueOf(false)));
    }

    public OUsersLoginPage(IModel<Boolean> restoreModel) {
        this.restoreModel = restoreModel;
    }

    public OUsersLoginPage(PageParameters params) {
        this();
        if (OrienteerUserModuleRepository.isOAuth2Active()) {
            String code = params.get("code").toOptionalString();
            String state = params.get("state").toOptionalString();
            if (!Strings.isNullOrEmpty((String)code) && !Strings.isNullOrEmpty((String)state)) {
                OAuth2Repository.getServiceContextByState(state).ifPresent(ctx -> this.authorize((OAuth2ServiceContext)((Object)ctx), code));
            }
        }
    }

    private void authorize(OAuth2ServiceContext ctx, String code) {
        try {
            boolean authorized = ctx.isRegistration() ? this.authService.register(ctx.getService(), code) : this.authService.authorize(ctx.getService(), code);
            if (authorized) {
                if (ctx.isSocialNetworkLink()) {
                    this.closeWindow = true;
                } else {
                    this.continueToOriginalDestination();
                    this.setResponsePage(this.getApplication().getHomePage());
                }
            }
        }
        catch (IllegalStateException ex) {
            this.error((Serializable)((Object)ex.getMessage()));
        }
        ctx.setUsed(true);
        DBClosure.sudoConsumer(db -> ctx.save());
    }

    protected void initialize(WebMarkupContainer container) {
        container.add(new Component[]{this.createRestorePasswordPanel("restorePasswordPanel")});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.closeWindow) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"window.close();"));
        }
    }

    protected WebMarkupContainer createRestorePasswordPanel(String id) {
        if (!OrienteerUserModuleRepository.isRestorePassword()) {
            return new EmptyPanel(id);
        }
        return new RestorePasswordPanel(id, this.restoreModel);
    }

    protected WebMarkupContainer createLoginPanel(String id) {
        List<OAuth2Service> services;
        if (OrienteerUserModuleRepository.isOAuth2Active() && !(services = OAuth2Repository.getOAuth2Services(true)).isEmpty()) {
            return new OUsersLoginPanel(id, (IModel)new ListModel(services)){

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(OUsersLoginPage.this.restoreModel.getObject() == null || (Boolean)OUsersLoginPage.this.restoreModel.getObject() == false);
                }
            };
        }
        return new LoginPanel(id){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(OUsersLoginPage.this.restoreModel.getObject() == null || (Boolean)OUsersLoginPage.this.restoreModel.getObject() == false);
            }

            protected LoginButtonsPanel createButtonsPanel(String id) {
                return new OUsersLoginButtonsPanel(id, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)arg_0 -> (this).onLoginButtonClick(arg_0)));
            }
        };
    }

    protected WebMarkupContainer createLoginFooter(String id) {
        if (OrienteerUserModuleRepository.isRegistrationActive()) {
            return new OUsersLoginFooterPanel(id);
        }
        return super.createLoginFooter(id);
    }

    protected String getContainerClasses(WebMarkupContainer loginPanel) {
        if (loginPanel instanceof OUsersLoginPanel) {
            return "col-md-6 card-group";
        }
        return super.getContainerClasses(loginPanel);
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof RestorePasswordEventPayload) {
            RestorePasswordEventPayload restorePayload = (RestorePasswordEventPayload)event.getPayload();
            if (((Boolean)this.restoreModel.getObject()).booleanValue() != restorePayload.isRestore()) {
                this.restoreModel.setObject((Object)restorePayload.isRestore());
                restorePayload.getAjaxRequestTarget().add(new Component[]{this.container});
            }
        }
    }
}

