/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.transponder.neo4j;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.orienteer.transponder.CommonUtils;
import org.orienteer.transponder.neo4j.Neo4JUtils;

public class EntityWrapper {
    protected Entity entity;

    public EntityWrapper() {
    }

    public EntityWrapper(Entity entity) {
        this.entity = entity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Object get(String property, Type type) {
        Class requiredClass = CommonUtils.typeToRequiredClass((Type)type);
        if (Neo4JUtils.isSupportedPropertyClass(requiredClass)) {
            return this.getProperty(property);
        }
        Class<? extends Entity> expectedEntityClass = Neo4JUtils.getExpectedEntityClass(requiredClass);
        if (expectedEntityClass == null) {
            return null;
        }
        if (Collection.class.isAssignableFrom(CommonUtils.typeToMasterClass((Type)type))) {
            return this.getMultiReferenced(property, Node.class.isAssignableFrom(expectedEntityClass));
        }
        return this.getSingleReferenced(property, Node.class.isAssignableFrom(expectedEntityClass));
    }

    public EntityWrapper set(String property, Object value, Type type) {
        Class requiredClass = CommonUtils.typeToRequiredClass((Type)type);
        if (Neo4JUtils.isSupportedPropertyClass(requiredClass)) {
            return this.setProperty(property, value);
        }
        Class<? extends Entity> expectedEntityClass = Neo4JUtils.getExpectedEntityClass(requiredClass);
        if (expectedEntityClass != null) {
            if (Collection.class.isAssignableFrom(CommonUtils.typeToMasterClass((Type)type))) {
                this.setMultiReferenced(property, (Collection)value, Node.class.isAssignableFrom(expectedEntityClass));
            } else {
                this.setSingleReferenced(property, (Entity)value, Node.class.isAssignableFrom(expectedEntityClass));
            }
        }
        return this;
    }

    public Object getProperty(String property) {
        if (this.entity.hasProperty(property)) {
            return this.entity.getProperty(property);
        }
        return null;
    }

    public Entity getSingleReferenced(String property, boolean isNodeNeeded) {
        if (this.entity instanceof Node) {
            Node node = (Node)this.entity;
            Relationship relationship = node.getSingleRelationship(RelationshipType.withName((String)property), Direction.OUTGOING);
            return isNodeNeeded ? relationship.getEndNode() : relationship;
        }
        if (this.entity instanceof Relationship) {
            Relationship relationship = (Relationship)this.entity;
            if ("start".equals(property)) {
                return relationship.getStartNode();
            }
            if ("end".equals(property)) {
                return relationship.getEndNode();
            }
        }
        return null;
    }

    public List<Entity> getMultiReferenced(String property, boolean isNodeNeeded) {
        if (this.entity instanceof Node) {
            Node node = (Node)this.entity;
            RelationshipType relationshipType = RelationshipType.withName((String)property);
            return StreamSupport.stream(node.getRelationships(Direction.OUTGOING, new RelationshipType[]{relationshipType}).spliterator(), false).map(r -> isNodeNeeded ? r.getEndNode() : r).collect(Collectors.toList());
        }
        return null;
    }

    public EntityWrapper setProperty(String property, Object value) {
        this.entity.setProperty(property, value);
        return this;
    }

    public void setSingleReferenced(String property, Entity value, boolean isNodeExpected) {
        if (this.entity instanceof Node) {
            Node node = (Node)this.entity;
            RelationshipType relationshipType = RelationshipType.withName((String)property);
            Relationship relationship = node.getSingleRelationship(relationshipType, Direction.OUTGOING);
            if (relationship != null) {
                if (Objects.equals(relationship.getEndNode(), value)) {
                    return;
                }
                relationship.delete();
            }
            if (value instanceof Node) {
                node.createRelationshipTo((Node)value, relationshipType);
            }
        }
    }

    public void setMultiReferenced(String property, Collection<Entity> value, boolean isNodeExpected) {
        if (this.entity instanceof Node) {
            Node node = (Node)this.entity;
            RelationshipType relationshipType = RelationshipType.withName((String)property);
            node.getRelationships(Direction.OUTGOING, new RelationshipType[]{relationshipType}).forEach(r -> {
                if (!value.contains(r.getEndNode())) {
                    r.delete();
                }
            });
            List<Entity> remaining = this.getMultiReferenced(property, true);
            ArrayList<Entity> toAdd = new ArrayList<Entity>(value);
            toAdd.removeAll(remaining);
            toAdd.forEach(n -> node.createRelationshipTo((Node)n, relationshipType));
        }
    }
}

