/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.transponder.neo4j;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.orienteer.transponder.IDriver;
import org.orienteer.transponder.neo4j.EntityWrapper;
import org.orienteer.transponder.neo4j.Neo4JUtils;

public class Neo4JDriver
implements IDriver {
    public static final String DIALECT_NEO4J = "neo4j";
    public static final String TYPE_CUSTOM_TRANSPONDER_WRAPPER = "transponder.wrapper";
    private static final BiMap<String, Class<?>> TYPE_TO_MAIN_CLASS = HashBiMap.create();
    private final GraphDatabaseService database;
    private Transaction externalTransaction;

    public Neo4JDriver(GraphDatabaseService database) {
        this.database = database;
    }

    public Neo4JDriver(GraphDatabaseService database, Transaction externalTransaction) {
        this.database = database;
        this.externalTransaction = externalTransaction;
    }

    public void createType(String typeName, boolean isAbstract, Class<?> mainWrapperClass, String ... superTypes) {
        TYPE_TO_MAIN_CLASS.put((Object)typeName, mainWrapperClass);
    }

    public void createProperty(String typeName, String propertyName, Type propertyType, String referencedType, int order, AnnotatedElement annotations) {
    }

    public void setupRelationship(String type1Name, String property1Name, String type2Name, String property2Name) {
    }

    public void createIndex(String typeName, String indexName, String indexType, AnnotatedElement annotations, String ... properties) {
    }

    public Object getPropertyValue(Object wrapper, String property, Type type) {
        return ((EntityWrapper)wrapper).get(property, type);
    }

    public void setPropertyValue(Object wrapper, String property, Object value, Type type) {
        ((EntityWrapper)wrapper).set(property, value, type);
    }

    public <T> T newEntityInstance(Class<T> proxyClass, String type) {
        try (TransactionHolder holder = new TransactionHolder();){
            T t = this.wrapEntityInstance(proxyClass, holder.getTransaction().createNode(new Label[]{Label.label((String)type)}));
            return t;
        }
    }

    public void saveEntityInstance(Object wrapper) {
    }

    public <T> T wrapEntityInstance(Class<T> proxyClass, Object seed) {
        try {
            return proxyClass.getConstructor(Entity.class).newInstance((Entity)seed);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't wrap seed by class " + proxyClass + ". Seed: " + seed, e);
        }
    }

    public Class<?> getDefaultEntityBaseClass() {
        return EntityWrapper.class;
    }

    public Class<?> getEntityMainClass(Object seed) {
        List<String> types = Neo4JUtils.entityToType((Entity)seed);
        for (String type : types) {
            Class mainClass = (Class)TYPE_TO_MAIN_CLASS.get((Object)type);
            if (mainClass == null) continue;
            return mainClass;
        }
        return null;
    }

    public boolean isSeedClass(Class<?> seedClass) {
        return Entity.class.isAssignableFrom(seedClass);
    }

    public Object toSeed(Object wrapped) {
        return ((EntityWrapper)wrapped).getEntity();
    }

    public List<Object> query(String language, String query, Map<String, Object> params) {
        try (TransactionHolder holder = new TransactionHolder();){
            List list;
            block11: {
                Transaction tx = holder.getTransaction();
                Result result = tx.execute(query, params);
                try {
                    List columns = result.columns();
                    List list2 = list = columns.size() > 0 ? result.columnAs((String)columns.get(0)).stream().collect(Collectors.toList()) : null;
                    if (result == null) break block11;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return list;
        }
    }

    public String getDialect() {
        return DIALECT_NEO4J;
    }

    public void replaceSeed(Object wrapper, Object newSeed) {
        ((EntityWrapper)wrapper).setEntity((Entity)newSeed);
    }

    public GraphDatabaseService getDatabase() {
        return this.database;
    }

    protected class TransactionHolder
    implements AutoCloseable {
        private Transaction transaction;

        protected TransactionHolder() {
        }

        public Transaction getTransaction() {
            if (Neo4JDriver.this.externalTransaction != null) {
                return Neo4JDriver.this.externalTransaction;
            }
            if (this.transaction == null) {
                this.transaction = Neo4JDriver.this.database.beginTx();
            }
            return this.transaction;
        }

        @Override
        public void close() {
            if (this.transaction != null) {
                this.transaction.commit();
                this.transaction.close();
            }
        }
    }
}

