/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.transponder.neo4j;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.orienteer.transponder.annotation.EntityType;
import org.orienteer.transponder.neo4j.Neo4JRelationship;

public final class Neo4JUtils {
    private static final Class<?>[] SUPPORTED_VALUES_CLASSES = new Class[]{String.class, Boolean.class, Number.class, Character.class, Temporal.class, TemporalAmount.class, Point.class};

    public static List<String> entityToType(Entity entity) {
        ArrayList<String> ret = new ArrayList<String>();
        if (entity instanceof Node) {
            ((Node)entity).getLabels().forEach(l -> ret.add(l.name()));
        } else if (entity instanceof Relationship) {
            ret.add(((Relationship)entity).getType().name());
        }
        return ret;
    }

    public static boolean isSupportedPropertyClass(Class<?> valueClass) {
        if (valueClass.isArray()) {
            valueClass = valueClass.getComponentType();
        }
        for (Class<?> supportedClass : SUPPORTED_VALUES_CLASSES) {
            if (!supportedClass.isAssignableFrom(valueClass)) continue;
            return true;
        }
        return false;
    }

    public static Class<? extends Entity> getExpectedEntityClass(Class<?> entity) {
        return entity.getAnnotation(EntityType.class) != null ? (entity.getAnnotation(Neo4JRelationship.class) != null ? Relationship.class : Node.class) : null;
    }

    private Neo4JUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

