/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.transponder.orientdb;

import com.google.common.base.Strings;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.orienteer.transponder.CommonUtils;
import org.orienteer.transponder.IDriver;
import org.orienteer.transponder.orientdb.OrientDBProperty;

public class ODriver
implements IDriver {
    public static final String DIALECT_ORIENTDB = "orientdb";
    public static final String OCLASS_CUSTOM_TRANSPONDER_WRAPPER = "transponder.wrapper";
    public static final String OINDEX_UNIQUE = "UNIQUE";
    public static final String OINDEX_NOTUNIQUE = "NOTUNIQUE";
    public static final String OINDEX_FULLTEXT = "FULLTEXT";
    public static final String OINDEX_DICTIONARY = "DICTIONARY";
    public static final String OINDEX_PROXY = "PROXY";
    public static final String OINDEX_UNIQUE_HASH_INDEX = "UNIQUE_HASH_INDEX";
    public static final String OINDEX_NOTUNIQUE_HASH_INDEX = "NOTUNIQUE_HASH_INDEX";
    public static final String OINDEX_DICTIONARY_HASH_INDEX = "DICTIONARY_HASH_INDEX";
    public static final String OINDEX_SPATIAL = OClass.INDEX_TYPE.SPATIAL.name();
    private static final Map<OType, OType> EMBEDDED_TO_LINKS_MAP = CommonUtils.toMap((Object[])new Object[]{OType.EMBEDDED, OType.LINK, OType.EMBEDDEDLIST, OType.LINKLIST, OType.EMBEDDEDSET, OType.LINKSET, OType.EMBEDDEDMAP, OType.LINKMAP});
    private final boolean overrideSchema;

    public ODriver() {
        this(false);
    }

    public ODriver(boolean overrideSchema) {
        this.overrideSchema = overrideSchema;
    }

    public void createType(String typeName, boolean isAbstract, Class<?> mainWrapperClass, String ... superTypes) {
        String transponderWrapperName;
        String currentValue;
        boolean existing;
        OSchema schema = this.getSchema();
        if (superTypes == null) {
            superTypes = new String[]{};
        }
        OClass[] superClasses = new OClass[superTypes.length];
        for (int i = 0; i < superTypes.length; ++i) {
            String superType = superTypes[i];
            superClasses[i] = schema.getClass(superType);
        }
        OClass oClass = schema.getClass(typeName);
        boolean bl = existing = oClass != null;
        if (!existing) {
            oClass = isAbstract ? schema.createAbstractClass(typeName, superClasses) : schema.createClass(typeName, superClasses);
        } else if (this.overrideSchema) {
            oClass.setSuperClasses(Arrays.asList(superClasses));
            if (isAbstract != oClass.isAbstract()) {
                oClass.setAbstract(isAbstract);
            }
        }
        if (!(existing && !this.overrideSchema || Objects.equals(currentValue = oClass.getCustom(OCLASS_CUSTOM_TRANSPONDER_WRAPPER), transponderWrapperName = mainWrapperClass.getName()))) {
            oClass.setCustom(OCLASS_CUSTOM_TRANSPONDER_WRAPPER, transponderWrapperName);
        }
    }

    public void createProperty(String typeName, String propertyName, Type propertyType, String linkedClassName, int order, AnnotatedElement annotations) {
        boolean shouldBeNotNull;
        OClass linkedClass;
        OProperty property;
        OType linkedType;
        Class requiredClass;
        OrientDBProperty annotation = annotations.getAnnotation(OrientDBProperty.class);
        OSchema schema = this.getSchema();
        OClass oClass = schema.getClass(typeName);
        Class masterClass = CommonUtils.typeToMasterClass((Type)propertyType);
        if (masterClass.equals(requiredClass = CommonUtils.typeToRequiredClass((Type)propertyType))) {
            requiredClass = null;
        }
        OType type = this.getTypeByClass(masterClass);
        if (annotation != null && !OType.ANY.equals((Object)annotation.type())) {
            type = annotation.type();
        }
        OType oType = linkedType = requiredClass == null || linkedClassName != null ? null : this.getTypeByClass(requiredClass);
        if (annotation != null && !OType.ANY.equals((Object)annotation.linkedType())) {
            linkedType = annotation.linkedType();
        }
        if (type == null && linkedClassName != null) {
            type = OType.EMBEDDED;
        }
        if (linkedClassName != null && EMBEDDED_TO_LINKS_MAP.containsKey(type) && (annotation == null || !annotation.embedded())) {
            type = EMBEDDED_TO_LINKS_MAP.get(type);
        }
        if (type == null) {
            type = OType.ANY;
        }
        boolean justCreated = (property = oClass.getProperty(propertyName)) == null;
        OClass oClass2 = linkedClass = linkedClassName != null ? schema.getClass(linkedClassName) : null;
        if (justCreated) {
            property = linkedClassName != null ? oClass.createProperty(propertyName, type, linkedClass) : oClass.createProperty(propertyName, type, linkedType);
        } else if (this.overrideSchema) {
            if (!Objects.equals(property.getType(), type)) {
                property.setType(type);
            }
            if (!Objects.equals(property.getLinkedType(), linkedType)) {
                property.setLinkedType(linkedType);
            }
            if (!Objects.equals(property.getLinkedClass(), linkedClass) && (linkedClass != null && linkedClassName != null || linkedClass == null && linkedClassName == null)) {
                property.setLinkedClass(linkedClass);
            }
        }
        boolean bl = shouldBeNotNull = propertyType instanceof Class && ((Class)propertyType).isPrimitive();
        if (annotation != null && (justCreated || this.overrideSchema)) {
            if (!Objects.equals(property.isNotNull(), shouldBeNotNull | annotation.notNull())) {
                property.setNotNull(shouldBeNotNull | annotation.notNull());
            }
            if (!Objects.equals(property.isMandatory(), annotation.mandatory())) {
                property.setMandatory(annotation.mandatory());
            }
            if (!Objects.equals(property.isReadonly(), annotation.readOnly())) {
                property.setReadonly(annotation.readOnly());
            }
            if (!Objects.equals(property.getMin(), Strings.emptyToNull((String)annotation.min()))) {
                property.setMin(Strings.emptyToNull((String)annotation.min()));
            }
            if (!Objects.equals(property.getMax(), Strings.emptyToNull((String)annotation.max()))) {
                property.setMax(annotation.max());
            }
            if (!Objects.equals(property.getRegexp(), Strings.emptyToNull((String)annotation.regexp()))) {
                property.setRegexp(Strings.emptyToNull((String)annotation.regexp()));
            }
            if (!Objects.equals(property.getCollate().getName(), annotation.collate())) {
                property.setCollate(annotation.collate());
            }
            if (!Objects.equals(property.getDefaultValue(), Strings.emptyToNull((String)annotation.defaultValue()))) {
                property.setDefaultValue(Strings.emptyToNull((String)annotation.defaultValue()));
            }
        }
        if (annotation == null && !Objects.equals(property.isNotNull(), shouldBeNotNull | property.isNotNull())) {
            property.setNotNull(shouldBeNotNull | property.isNotNull());
        }
    }

    public void createIndex(String typeName, String indexName, String indexType, AnnotatedElement annotations, String ... properties) {
        OSchema schema = this.getSchema();
        OClass oClass = schema.getClass(typeName);
        if (oClass.getClassIndex(indexName) == null) {
            oClass.createIndex(indexName, CommonUtils.defaultIfNullOrEmpty((String)indexType, (String)OINDEX_NOTUNIQUE), properties);
        }
    }

    public void setupRelationship(String type1Name, String property1Name, String type2Name, String property2Name) {
        OProperty property2;
        OSchema schema = this.getSchema();
        OClass class1 = schema.getClass(type1Name);
        OProperty property1 = class1.getProperty(property1Name);
        OClass class2 = schema.getClass(type2Name);
        OProperty oProperty = property2 = property2Name != null ? class2.getProperty(property2Name) : null;
        if (!Objects.equals(property1.getLinkedClass(), class2)) {
            property1.setLinkedClass(class2);
        }
        if (property2 != null && !Objects.equals(property2.getLinkedClass(), class1)) {
            property2.setLinkedClass(class1);
        }
    }

    public Object getPropertyValue(Object wrapper, String property, Type type) {
        if (wrapper == null) {
            return null;
        }
        ODocument doc = ((ODocumentWrapper)wrapper).getDocument();
        return doc != null ? doc.field(property) : null;
    }

    public void setPropertyValue(Object wrapper, String property, Object value, Type type) {
        if (wrapper == null) {
            return;
        }
        ODocument doc = ((ODocumentWrapper)wrapper).getDocument();
        if (doc != null) {
            doc.field(property, value);
        }
    }

    public <T> T newEntityInstance(Class<T> proxyClass, String type) {
        try {
            ODocument doc = new ODocument(type);
            return proxyClass.getConstructor(ODocument.class).newInstance(doc);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't create new entityInstance for class " + proxyClass + " with OClass " + type, e);
        }
    }

    public void saveEntityInstance(Object wrapper) {
        ODriver.asWrapper(wrapper).save();
    }

    public <T> T wrapEntityInstance(Class<T> proxyClass, Object seed) {
        try {
            ODocument doc = (ODocument)((OIdentifiable)seed).getRecord();
            return proxyClass.getConstructor(ODocument.class).newInstance(doc);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't wrap seed by class " + proxyClass + ". Seed: " + seed, e);
        }
    }

    public Class<?> getDefaultEntityBaseClass() {
        return ODocumentWrapper.class;
    }

    public Class<?> getEntityMainClass(Object seed) {
        String mainWrapperClassName;
        if (seed == null) {
            return null;
        }
        ODocument doc = (ODocument)((OIdentifiable)seed).getRecord();
        if (doc != null && !Strings.isNullOrEmpty((String)(mainWrapperClassName = doc.getSchemaClass().getCustom(OCLASS_CUSTOM_TRANSPONDER_WRAPPER)))) {
            try {
                return Class.forName(mainWrapperClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isSeedClass(Class<?> seedClass) {
        return OIdentifiable.class.isAssignableFrom(seedClass);
    }

    public Object toSeed(Object wrapped) {
        if (wrapped == null) {
            return null;
        }
        return ((ODocumentWrapper)wrapped).getDocument();
    }

    public List<Object> query(String language, String query, Map<String, Object> params) {
        try (OResultSet resultSet = this.getSession().query(query, params);){
            List<Object> list = resultSet.elementStream().map(e -> {
                ODocument doc = (ODocument)e;
                if (doc.getClassName() != null) {
                    return doc;
                }
                return (ODocument)doc.field("value");
            }).collect(Collectors.toList());
            return list;
        }
    }

    public Object querySingle(String language, String query, Map<String, Object> params) {
        try (OResultSet resultSet = this.getSession().query(query, params);){
            Object var5_5 = resultSet.elementStream().map(e -> {
                ODocument doc = (ODocument)e;
                if (doc.getClassName() != null) {
                    return doc;
                }
                return (ODocument)doc.field("value");
            }).findFirst().orElse(null);
            return var5_5;
        }
    }

    public Object command(String language, String command, Map<String, Object> params) {
        try (OResultSet resultSet = this.getSession().command(command, params);){
            List ret = resultSet.elementStream().map(e -> {
                ODocument doc = (ODocument)e;
                if (doc.getClassName() != null) {
                    return doc;
                }
                return (ODocument)doc.field("value");
            }).collect(Collectors.toList());
            List list = ret.isEmpty() ? null : (ret.size() == 1 ? ret.get(0) : ret);
            return list;
        }
    }

    public void replaceSeed(Object wrapper, Object newSeed) {
        ((ODocumentWrapper)wrapper).fromStream((ODocument)((OIdentifiable)newSeed).getRecord());
    }

    public String getDialect() {
        return DIALECT_ORIENTDB;
    }

    protected ODatabaseSession getSession() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        if (db == null) {
            throw new IllegalStateException("OrientDB Session is not associated with current thread");
        }
        return db;
    }

    protected OSchema getSchema() {
        return this.getSession().getMetadata().getSchema();
    }

    private OType getTypeByClass(Class<?> clazz) {
        OType ret = OType.getTypeByClass(clazz);
        if (OType.CUSTOM.equals((Object)ret) && Serializable.class.isAssignableFrom(clazz)) {
            ret = null;
        }
        return ret;
    }

    public static ODocumentWrapper asWrapper(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ODocumentWrapper) {
            return (ODocumentWrapper)obj;
        }
        throw new IllegalStateException("Object is not a wrapper. Object: " + obj);
    }

    public static ODocument asDocument(Object obj) {
        return obj != null ? ODriver.asWrapper(obj).getDocument() : null;
    }

    public static <T> T save(T obj) {
        ODriver.asWrapper(obj).save();
        return obj;
    }

    public static <T> T reload(T obj) {
        ODriver.asWrapper(obj).reload();
        return obj;
    }
}

