/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject;

import java.lang.annotation.Annotation;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Genie;
import org.osgl.inject.ScopeCache;
import org.osgl.inject.annotation.RequestScoped;
import org.osgl.inject.annotation.SessionScoped;

class ScopedProvider<T>
implements Provider<T> {
    private Provider<T> realProvider;
    private Class<T> targetClass;
    private ScopeCache cache;

    private ScopedProvider(Class<T> targetClass, ScopeCache cache, Provider<T> realProvider) {
        this.targetClass = targetClass;
        this.realProvider = realProvider;
        this.cache = cache;
    }

    public T get() {
        Object bean = this.cache.get(this.targetClass);
        if (null == bean) {
            bean = this.realProvider.get();
        }
        this.cache.put(this.targetClass, bean);
        return bean;
    }

    static <T> Provider<T> decorate(BeanSpec spec, Provider<T> realProvider, Genie genie) {
        if (realProvider instanceof ScopedProvider) {
            return realProvider;
        }
        Class targetClass = spec.rawType();
        ScopeCache cache = ScopedProvider.resolve(spec.scope(), genie);
        return null == cache ? realProvider : new ScopedProvider<T>(targetClass, cache, realProvider);
    }

    static ScopeCache resolve(Class<? extends Annotation> annoClass, Genie genie) {
        ScopeCache cache = ScopedProvider.resolveBuiltIn(annoClass, genie);
        if (null != cache) {
            return cache;
        }
        Class<? extends Annotation> alias = genie.scopeByAlias(annoClass);
        if (null != alias) {
            cache = ScopedProvider.resolveBuiltIn(alias, genie);
        }
        if (null == cache) {
            cache = genie.scopeCache(annoClass);
        }
        return cache;
    }

    private static ScopeCache resolveBuiltIn(Class<? extends Annotation> annoClass, Genie genie) {
        if (Singleton.class == annoClass) {
            return genie.get(ScopeCache.SingletonScope.class);
        }
        if (RequestScoped.class == annoClass) {
            return genie.get(ScopeCache.RequestScope.class);
        }
        if (SessionScoped.class == annoClass) {
            return genie.get(ScopeCache.SessionScope.class);
        }
        return null;
    }
}

