/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject.util;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ArrayLoader<T> {
    private static final DefaultArrayLoader DEF_LOADER = new DefaultArrayLoader();
    private static final Map<Class, ArrayLoader> loaders = new HashMap<Class, ArrayLoader>();

    public abstract T loadFrom(List var1, Class var2);

    public static Object listToArray(List list, Class elementType) {
        ArrayLoader loader = loaders.get(elementType);
        if (null == loader) {
            loader = DEF_LOADER;
        }
        return loader.loadFrom(list, elementType);
    }

    static {
        loaders.put(Boolean.class, new BooleanArrayLoader());
        loaders.put(Boolean.TYPE, new BoolArrayLoader());
        loaders.put(Byte.class, new ByteArrayLoader());
        loaders.put(Byte.TYPE, new PrimitiveByteArrayLoader());
        loaders.put(Character.class, new CharacterArrayLoader());
        loaders.put(Character.TYPE, new CharArrayLoader());
        loaders.put(Short.class, new ShortArrayLoader());
        loaders.put(Short.TYPE, new PrimitiveShortArrayLoader());
        loaders.put(Integer.class, new IntegerArrayLoader());
        loaders.put(Integer.TYPE, new IntArrayLoader());
        loaders.put(Float.class, new FloatArrayLoader());
        loaders.put(Float.TYPE, new PrimitiveFloatArrayLoader());
        loaders.put(Long.class, new LongArrayLoader());
        loaders.put(Long.TYPE, new PrimitiveLongArrayLoader());
        loaders.put(Double.class, new DoubleArrayLoader());
        loaders.put(Double.TYPE, new PrimitiveDoubleArrayLoader());
        loaders.put(String.class, new StringArrayLoader());
        loaders.put(Date.class, new DateArrayLoader());
    }

    private static class DateArrayLoader
    extends ArrayLoader<Date[]> {
        private DateArrayLoader() {
        }

        @Override
        public Date[] loadFrom(List list, Class elementType) {
            return list.toArray(new Date[list.size()]);
        }
    }

    private static class StringArrayLoader
    extends ArrayLoader<String[]> {
        private StringArrayLoader() {
        }

        @Override
        public String[] loadFrom(List list, Class elementType) {
            return list.toArray(new String[list.size()]);
        }
    }

    private static class DoubleArrayLoader
    extends ArrayLoader<Double[]> {
        private DoubleArrayLoader() {
        }

        @Override
        public Double[] loadFrom(List list, Class elementType) {
            return list.toArray(new Double[list.size()]);
        }
    }

    private static class PrimitiveDoubleArrayLoader
    extends ArrayLoader<double[]> {
        private PrimitiveDoubleArrayLoader() {
        }

        @Override
        public double[] loadFrom(List list, Class elementType) {
            int sz = list.size();
            double[] a = new double[sz];
            int i = 0;
            for (Object o : list) {
                a[i++] = (Double)o;
            }
            return a;
        }
    }

    private static class LongArrayLoader
    extends ArrayLoader<Long[]> {
        private LongArrayLoader() {
        }

        @Override
        public Long[] loadFrom(List list, Class elementType) {
            return list.toArray(new Long[list.size()]);
        }
    }

    private static class PrimitiveLongArrayLoader
    extends ArrayLoader<long[]> {
        private PrimitiveLongArrayLoader() {
        }

        @Override
        public long[] loadFrom(List list, Class elementType) {
            int sz = list.size();
            long[] a = new long[sz];
            int i = 0;
            for (Object o : list) {
                a[i++] = (Long)o;
            }
            return a;
        }
    }

    private static class FloatArrayLoader
    extends ArrayLoader<Float[]> {
        private FloatArrayLoader() {
        }

        @Override
        public Float[] loadFrom(List list, Class elementType) {
            return list.toArray(new Float[list.size()]);
        }
    }

    private static class PrimitiveFloatArrayLoader
    extends ArrayLoader<float[]> {
        private PrimitiveFloatArrayLoader() {
        }

        @Override
        public float[] loadFrom(List list, Class elementType) {
            int sz = list.size();
            float[] a = new float[sz];
            int i = 0;
            for (Object o : list) {
                a[i++] = ((Float)o).floatValue();
            }
            return a;
        }
    }

    private static class IntegerArrayLoader
    extends ArrayLoader<Integer[]> {
        private IntegerArrayLoader() {
        }

        @Override
        public Integer[] loadFrom(List list, Class elementType) {
            return list.toArray(new Integer[list.size()]);
        }
    }

    private static class IntArrayLoader
    extends ArrayLoader<int[]> {
        private IntArrayLoader() {
        }

        @Override
        public int[] loadFrom(List list, Class elementType) {
            int sz = list.size();
            int[] a = new int[sz];
            int i = 0;
            for (Object o : list) {
                a[i++] = (Integer)o;
            }
            return a;
        }
    }

    private static class ShortArrayLoader
    extends ArrayLoader<Short[]> {
        private ShortArrayLoader() {
        }

        @Override
        public Short[] loadFrom(List list, Class elementType) {
            return list.toArray(new Short[list.size()]);
        }
    }

    private static class PrimitiveShortArrayLoader
    extends ArrayLoader<short[]> {
        private PrimitiveShortArrayLoader() {
        }

        @Override
        public short[] loadFrom(List list, Class elementType) {
            int sz = list.size();
            short[] a = new short[sz];
            int i = 0;
            for (Object o : list) {
                a[i++] = (Short)o;
            }
            return a;
        }
    }

    private static class CharacterArrayLoader
    extends ArrayLoader<Character[]> {
        private CharacterArrayLoader() {
        }

        @Override
        public Character[] loadFrom(List list, Class elementType) {
            return list.toArray(new Character[list.size()]);
        }
    }

    private static class CharArrayLoader
    extends ArrayLoader<char[]> {
        private CharArrayLoader() {
        }

        @Override
        public char[] loadFrom(List list, Class elementType) {
            int sz = list.size();
            char[] a = new char[sz];
            int i = 0;
            for (Object o : list) {
                a[i++] = ((Character)o).charValue();
            }
            return a;
        }
    }

    private static class ByteArrayLoader
    extends ArrayLoader<Byte[]> {
        private ByteArrayLoader() {
        }

        @Override
        public Byte[] loadFrom(List list, Class elementType) {
            return list.toArray(new Byte[list.size()]);
        }
    }

    private static class PrimitiveByteArrayLoader
    extends ArrayLoader<byte[]> {
        private PrimitiveByteArrayLoader() {
        }

        @Override
        public byte[] loadFrom(List list, Class elementType) {
            int sz = list.size();
            byte[] a = new byte[sz];
            int i = 0;
            for (Object o : list) {
                a[i++] = (Byte)o;
            }
            return a;
        }
    }

    private static class BooleanArrayLoader
    extends ArrayLoader<Boolean[]> {
        private BooleanArrayLoader() {
        }

        @Override
        public Boolean[] loadFrom(List list, Class elementType) {
            return list.toArray(new Boolean[list.size()]);
        }
    }

    private static class BoolArrayLoader
    extends ArrayLoader<boolean[]> {
        private BoolArrayLoader() {
        }

        @Override
        public boolean[] loadFrom(List list, Class elementType) {
            int sz = list.size();
            boolean[] a = new boolean[sz];
            int i = 0;
            for (Object o : list) {
                a[i++] = (Boolean)o;
            }
            return a;
        }
    }

    static class DefaultArrayLoader
    extends ArrayLoader {
        DefaultArrayLoader() {
        }

        public Object loadFrom(List list, Class elementType) {
            int sz = list.size();
            Object array = Array.newInstance(elementType, sz);
            for (int i = 0; i < sz; ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
    }
}

