/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Genie;

class PostConstructorInvoker<T>
implements Provider<T> {
    private Provider<T> realProvider;
    private Method postConstructor;

    private PostConstructorInvoker(Provider<T> realProvider, Method postConstructor) {
        this.realProvider = realProvider;
        this.postConstructor = postConstructor;
    }

    public T get() {
        Object t = this.realProvider.get();
        $.invokeVirtual((Object)t, (Method)this.postConstructor, (Object[])new Object[0]);
        return (T)t;
    }

    static <T> Provider<T> decorate(BeanSpec spec, Provider<T> realProvider, Genie genie) {
        if (realProvider instanceof PostConstructorInvoker) {
            return realProvider;
        }
        Method postConstructor = PostConstructorInvoker.findPostConstructor(spec.rawType());
        return null == postConstructor ? realProvider : new PostConstructorInvoker<T>(realProvider, postConstructor);
    }

    private static Method findPostConstructor(Class<?> type) {
        for (Method m : type.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || Void.TYPE != m.getReturnType() || !m.isAnnotationPresent(PostConstruct.class)) continue;
            m.setAccessible(true);
            return m;
        }
        Class<?> parent = type.getSuperclass();
        if (null != parent && Object.class != parent) {
            return PostConstructorInvoker.findPostConstructor(parent);
        }
        return null;
    }
}

